package PDK::Config::Context::Role;

use utf8;
use v5.30;
use Moose::Role;

# 实体标识符
has id => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
);

# 实体名称或标签
has name => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

# 实现类型、平台或来源标识符
has vendor => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

# 配置签名，用于唯一标识配置内容
has confSign => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

# 与配置数据关联的时间戳
has timestamp => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

# 跟踪每行配置解析状态的数组引用
has lineParsedFlags => (
    is      => 'ro',
    isa     => 'ArrayRef[Int]',
    builder => '_buildLineParsedFlags',
);

# 必需的方法
requires 'config';
requires 'confContent';
requires 'cursor';
requires 'goToHead';
requires 'nextLine';
requires 'prevLine';
requires 'nextUnParsedLine';
requires 'backtrack';
requires 'ignore';
requires 'getUnParsedLines';

1;

__END__

=encoding utf8

=head1 NAME

PDK::Config::Context::Role - 通用配置解析上下文角色

=head1 VERSION

0.001

=head1 SYNOPSIS

    package PDK::Config::Context::Text;

    use Moose;
    with 'PDK::Config::Context::Role';

    sub config            { ... }
    sub confContent       { ... }
    sub cursor            { ... }
    sub goToHead          { ... }
    sub nextLine          { ... }
    sub prevLine          { ... }
    sub nextUnParsedLine  { ... }
    sub backtrack         { ... }
    sub ignore            { ... }
    sub getUnParsedLines  { ... }

=head1 DESCRIPTION

此角色定义了配置内容的通用解析上下文。

它有意设计为领域无关的，可用于解析任何面向行的配置、脚本或结构化文本格式。

该角色提供：

=over 4

=item *

通用元数据（id、name、vendor）

=item *

配置标识和时间戳

=item *

逐行解析状态跟踪

=item *

基于光标的解析的严格方法契约

=back

=head1 ATTRIBUTES

=head2 id

实体标识符。

    is       => 'ro',
    isa      => 'Int',
    required => 1,

=head2 name

实体名称或标签。

    is       => 'ro',
    isa      => 'Str',
    required => 1,

=head2 vendor

实现类型、平台或来源标识符。

    is       => 'ro',
    isa      => 'Str',
    required => 1,

=head2 confSign

用于唯一标识配置内容的配置签名（例如哈希值）。

    is       => 'ro',
    isa      => 'Str',
    required => 1,

=head2 timestamp

与配置数据关联的时间戳。

    is       => 'ro',
    isa      => 'Str',
    required => 1,

=head2 lineParsedFlags

跟踪每行配置解析状态的数组引用。

    is      => 'ro',
    isa     => 'ArrayRef[Int]',
    builder => '_buildLineParsedFlags',

=head1 REQUIRED METHODS

任何使用此角色的类 B<必须>实现以下方法：

=head2 config

返回包含配置行的数组引用。

=head2 confContent

返回原始配置内容字符串。

=head2 cursor

返回当前光标位置。

=head2 goToHead

将光标移动到内容开头。

=head2 nextLine

前进光标并返回下一行。

=head2 prevLine

将光标向后移动并返回上一行。

=head2 nextUnParsedLine

将光标移动到并返回下一个未解析的行。

=head2 backtrack

将光标向后移动并将该行标记为未解析。

=head2 ignore

将当前行标记为已解析并前进光标。

=head2 getUnParsedLines

返回所有剩余的未解析行。

=head1 AUTHOR

careline <968828@gmail.com>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
