package Google::Ads::AdWords::v201209::CustomerSyncSelector;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/ch/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %dateTimeRange_of :ATTR(:get<dateTimeRange>);
my %campaignIds_of :ATTR(:get<campaignIds>);

__PACKAGE__->_factory(
    [ qw(        dateTimeRange
        campaignIds

    ) ],
    {
        'dateTimeRange' => \%dateTimeRange_of,
        'campaignIds' => \%campaignIds_of,
    },
    {
        'dateTimeRange' => 'Google::Ads::AdWords::v201209::DateTimeRange',
        'campaignIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'dateTimeRange' => 'dateTimeRange',
        'campaignIds' => 'campaignIds',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::CustomerSyncSelector

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CustomerSyncSelector from the namespace https://adwords.google.com/api/adwords/ch/v201209.

A filter for selecting changehistory events for a customer. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * dateTimeRange


=item * campaignIds




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201209::CustomerSyncSelector
   dateTimeRange =>  $a_reference_to, # see Google::Ads::AdWords::v201209::DateTimeRange
   campaignIds =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

