
package Paws::RDS::CreateEventSubscription;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool');
  has EventCategories => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SnsTopicArn => (is => 'ro', isa => 'Str', required => 1);
  has SourceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SourceType => (is => 'ro', isa => 'Str');
  has SubscriptionName => (is => 'ro', isa => 'Str', required => 1);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::RDS::Tag]');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'CreateEventSubscription');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::RDS::CreateEventSubscriptionResult');
  class_has _result_key => (isa => 'Str', is => 'ro', default => 'CreateEventSubscriptionResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::RDS::CreateEventSubscription - Arguments for method CreateEventSubscription on L<Paws::RDS>

=head1 DESCRIPTION

This class represents the parameters used for calling the method CreateEventSubscription on the
L<Amazon Relational Database Service|Paws::RDS> service. Use the attributes of this class
as arguments to method CreateEventSubscription.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to CreateEventSubscription.

=head1 SYNOPSIS

    my $rds = Paws->service('RDS');
    # To create an event notification subscription
    # This example creates an event notification subscription.
    my $CreateEventSubscriptionResult = $rds->CreateEventSubscription(
      'Enabled'          => 1,
      'EventCategories'  => ['availability'],
      'SnsTopicArn'      => 'arn:aws:sns:us-east-1:992648334831:MyDemoSNSTopic',
      'SourceIds'        => ['mymysqlinstance'],
      'SourceType'       => 'db-instance',
      'SubscriptionName' => 'mymysqleventsubscription'
    );

    # Results:
    my $EventSubscription = $CreateEventSubscriptionResult->EventSubscription;

    # Returns a L<Paws::RDS::CreateEventSubscriptionResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/rds/CreateEventSubscription>

=head1 ATTRIBUTES


=head2 Enabled => Bool

A value that indicates whether to activate the subscription. If the
event notification subscription isn't activated, the subscription is
created but not active.



=head2 EventCategories => ArrayRef[Str|Undef]

A list of event categories for a particular source type (C<SourceType>)
that you want to subscribe to. You can see a list of the categories for
a given source type in Events
(https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
in the I<Amazon RDS User Guide> or by using the
C<DescribeEventCategories> operation.



=head2 B<REQUIRED> SnsTopicArn => Str

The Amazon Resource Name (ARN) of the SNS topic created for event
notification. The ARN is created by Amazon SNS when you create a topic
and subscribe to it.



=head2 SourceIds => ArrayRef[Str|Undef]

The list of identifiers of the event sources for which events are
returned. If not specified, then all sources are included in the
response. An identifier must begin with a letter and must contain only
ASCII letters, digits, and hyphens. It can't end with a hyphen or
contain two consecutive hyphens.

Constraints:

=over

=item *

If C<SourceIds> are supplied, C<SourceType> must also be provided.

=item *

If the source type is a DB instance, a C<DBInstanceIdentifier> value
must be supplied.

=item *

If the source type is a DB cluster, a C<DBClusterIdentifier> value must
be supplied.

=item *

If the source type is a DB parameter group, a C<DBParameterGroupName>
value must be supplied.

=item *

If the source type is a DB security group, a C<DBSecurityGroupName>
value must be supplied.

=item *

If the source type is a DB snapshot, a C<DBSnapshotIdentifier> value
must be supplied.

=item *

If the source type is a DB cluster snapshot, a
C<DBClusterSnapshotIdentifier> value must be supplied.

=back




=head2 SourceType => Str

The type of source that is generating the events. For example, if you
want to be notified of events generated by a DB instance, you set this
parameter to C<db-instance>. If this value isn't specified, all events
are returned.

Valid values: C<db-instance> | C<db-cluster> | C<db-parameter-group> |
C<db-security-group> | C<db-snapshot> | C<db-cluster-snapshot>



=head2 B<REQUIRED> SubscriptionName => Str

The name of the subscription.

Constraints: The name must be less than 255 characters.



=head2 Tags => ArrayRef[L<Paws::RDS::Tag>]






=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method CreateEventSubscription in L<Paws::RDS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

