/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.impl.sql.execute.ValueRow;

public class IndexRow
extends ValueRow
implements ExecIndexRow {
    private boolean[] orderedNulls;

    public IndexRow() {
    }

    public IndexRow(int n) {
        super(n);
        this.orderedNulls = new boolean[n];
    }

    public void orderedNulls(int n) {
        this.orderedNulls[n] = true;
    }

    public boolean areNullsOrdered(int n) {
        return this.orderedNulls[n];
    }

    public void execRowToExecIndexRow(ExecRow execRow) {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = this.nColumns();
        this.orderedNulls = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.orderedNulls[i] = objectInput.readBoolean();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        int n = this.nColumns();
        for (int i = 0; i < n; ++i) {
            objectOutput.writeBoolean(this.orderedNulls[i]);
        }
    }

    public int getTypeFormatId() {
        return 238;
    }

    ExecRow cloneMe() {
        return new IndexRow(this.nColumns());
    }
}

