#DBFUNC_VERBOSE=
#DBFUNC_LOGFILE=
DBFUNC_DB_HOST="${DBFUNC_DB_HOST:-localhost}"
DBFUNC_DB_PORT="${DBFUNC_DB_PORT:-5432}"
#DBFUNC_DB_USER=
#DBFUNC_DB_DATABASE=
#DBFUNC_DB_PGPASSFILE=

PSQL="${PSQL:-psql}"
PG_DUMP="${PG_DUMP:-pg_dump}"
NULL=

die() {
	local m="$1"
	echo "FATAL: ${m}" >&2
	exit 1
}

dbfunc_init() {
	if [ -n "${DBFUNC_DB_PGPASSFILE}" ]; then
		export PGPASSFILE="${DBFUNC_DB_PGPASSFILE}"
		unset PGPASSWORD
	fi
}

dbfunc_cleanup() {
	:
}

dbfunc_psql_raw() {
	LC_ALL="C" "${PSQL}" \
		-w \
		--pset=tuples_only=on \
		${DBFUNC_LOGFILE:+--log-file="${DBFUNC_LOGFILE}"} \
		--host="${DBFUNC_DB_HOST}" \
		--port="${DBFUNC_DB_PORT}" \
		--username="${DBFUNC_DB_USER}" \
		--dbname="${DBFUNC_DB_DATABASE}" \
		"$@"
}

dbfunc_psql() {
	dbfunc_psql_raw \
		--set ON_ERROR_STOP=1 \
		${DBFUNC_VERBOSE:+--echo-all} \
		"$@"
}

dbfunc_psql_die() {
	dbfunc_psql "$@" || die "Cannot execute sql command: $*"
}

dbfunc_psql_file_on_schema() {
	local sqlfile=$1
	local tmpfile=$(mktemp)
	echo "SET search_path TO ${DBFUNC_DB_SCHEMA};" > "${tmpfile}"
	cat "${sqlfile}" >> "${tmpfile}"
	dbfunc_psql --file="${tmpfile}"
	rm -f "${tmpfile}"
}

dbfunc_psql_file_on_schema_die() {
	dbfunc_psql_file_on_schema "$@" || die "Cannot execute sql command: $*"
}

dbfunc_psql_allow_errors() {
	dbfunc_psql_raw \
		${DBFUNC_VERBOSE:+--echo-all} \
		"$@"
}

dbfunc_psql_statement_parsable() {
	local statement="$1"
	dbfunc_psql_raw \
		-c "copy (${statement}) to stdout with delimiter as '|';"
}

dbfunc_get_psql_result() {
	echo $(dbfunc_psql_raw -c "$@" | tr -d ' ')
}

#
# parse line escape, each field
# in own line
#
dbfunc_psql_statement_parse_line() {
	local NL="
"
	local line="$1"
	local ret=""

	[ -z "${line}" ] && return 0

	local escape=
	while [ -n "${line}" ]; do
		c="$(expr substr "${line}" 1 1)"
		line="$(expr substr "${line}" 2 $((${#line}+1)))"
		if [ -n "${escape}" ]; then
			escape=
			echo -n "$c"
		else
			case "${c}" in
				\\) escape=1 ;;
				\|) ret="${ret}${NL}" ;;
				*) ret="${ret}${c}" ;;
			esac
		fi
	done
	echo "${ret}"
}

dbfunc_pg_dump() {
	LC_ALL="C" "${PG_DUMP}" \
		-w \
		--host="${DBFUNC_DB_HOST}" \
		--port="${DBFUNC_DB_PORT}" \
		--username="${DBFUNC_DB_USER}" \
		"$@" \
		"${DBFUNC_DB_DATABASE}"
}

dbfunc_pg_dump_die() {
	dbfunc_pg_dump "$@" || die "Cannot execute pg_dump command: $*"
}
