# -*- coding: utf-8 -*-
import sys
import urllib
import urllib2
import urlparse
import json
import xbmcgui
import xbmcplugin
import xbmcaddon
import os
import re
sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'resources', 'lib'))
__addon__ = xbmcaddon.Addon()
from planettv.logging import log, LOGLEVEL, log_error
#######################################

#functions
def build_url(base, query):
	return base+'?'+urllib.urlencode(query)
#######################################

#main
if __name__ == "__main__":
	try:
		#get add-on base url
		base = str(sys.argv[0])

		#get add-on handle
		handle = int(sys.argv[1])
		addon_handle = int(sys.argv[1])

		#get add-on args
		args = urlparse.parse_qs(sys.argv[2][1:])

		#get mode and other parameters
		modeArg = args.get('mode', ['0'])
		mode = int(modeArg[0])
		show_titleArg = args.get('show', ('showAll'))
		show_title = show_titleArg[0]
		limit = 20
		offsetArg = args.get('new_offset', ['0'])
		offset = offsetArg[0]
		datesort = 'desc'

		#planet tv base url:
		domain = 'http://www.planet.si/ajax/'
		stage1 = 'lazy-load-video.html?'
		stage2 = 'video.html?id='
		image = 'http://www.planet.si'

		xbmcplugin.setContent(handle, 'tvshows')

		#step 1: Collect underpants...
		if mode == 0:
			#mode == 0: list main menu
			#log("(Main) Creting main menu, mode:%s" %mode, LOGLEVEL.INFO)
			#PLANET TV V ŽIVO (when selected starts playing stream)
			li = xbmcgui.ListItem('Planet TV Live', iconImage=os.path.join(xbmcaddon.Addon('plugin.video.planettv').getAddonInfo('path'), 'resources', 'media', 'icon.png'))
			url = 'http://live.planet.si/stream2/03.m3u8'
			xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li)

			#ARHIV ODDAJ
			li = xbmcgui.ListItem('Planet TV Arhiv')
			url = build_url(base, {'mode': 1})
			xbmcplugin.addDirectoryItem(handle=handle, url=url, listitem=li, isFolder=True)

		#step 2: ...?...
		elif mode == 1:
			#mode == 1: (ARHIV ODDAJ) get list of all shows from planettv.si
			li = xbmcgui.ListItem('Prikaži vse')
			url = build_url(base, {'mode': 11, 'show': 'showAll'})
			xbmcplugin.addDirectoryItem(handle=handle, url=url, listitem=li, isFolder=True)

			request_tv = urllib2.Request(domain+stage1+'populateFilters=true', headers = {"User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "Accept-Encoding": "none"})
			response_tv = json.loads(urllib2.urlopen(request_tv).read())
			tvshows = response_tv.get('filters').get('tvShows')
			#log("(TV_shows) %s" %tvshows, LOGLEVEL.INFO)
			for s in tvshows:
				#log("(TV_show) Item %s" %s, LOGLEVEL.INFO)
				query_change = s.get('title').encode('utf8').replace(' ', '+').replace('č', '%C4%8D').replace('š', '%C5%A1').replace('ž', '%C5%BE')
				#log("(TV_show) Adding Item %s" %s.get('title').encode('utf8'), LOGLEVEL.INFO)
				li = xbmcgui.ListItem(s.get('title').encode('utf8'))
				url = build_url(base, {'mode': 11, 'show': query_change})
				xbmcplugin.addDirectoryItem(handle=handle, url=url, listitem=li, isFolder=True)

		elif mode == 11:
			#mode == 11: (ARHIV IZBRANE ODDAJE) TODO list of items for selected shows

			query = 'limit=%s&offset=%s&tpl=tv_archive_video_item&filter[datesort]=%s&filters[tvshow]=%s&populatefilters=true' % (limit, offset, datesort, show_title)
			query1 = domain+stage1+query
			#log("(query) %s" %query1, LOGLEVEL.INFO)

			req = urllib2.Request(query1, headers = {"User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "Accept-Encoding": "none"})
			response = urllib2.urlopen(req).read()
			#log("(response) %s" %responsedata, LOGLEVEL.INFO)

			videoId_regex = re.findall('video_[0-9]{5}', response)
			#log("(regex) %s" %videoId_regex, LOGLEVEL.INFO)

			for video in videoId_regex:
				videoId = video.replace('video_','')
				#log("(videoId) %s" %videoId, LOGLEVEL.INFO)
				query2 = domain+stage2+videoId
				req1 = req = urllib2.Request(query2, headers = {"User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "Accept-Encoding": "none"})
				response1 = json.loads(urllib2.urlopen(req1).read())
				#log("(response) %s" %response1, LOGLEVEL.INFO)

				li = xbmcgui.ListItem(response1.get('title'), iconImage=image+response1.get('image'))
				for video_stream in response1.get('sources'):
					if video_stream.get('label') == 'HLS':
						url = video_stream.get('file')
						#log("(video_url) %s" %url, LOGLEVEL.INFO)
				xbmcplugin.addDirectoryItem(handle=addon_handle, url=url, listitem=li)

			li = xbmcgui.ListItem('Starejši posnetki')
			url = build_url(base, {'mode': 11, 'show': show_title, 'new_offset': int(offset)+int(limit)})
			xbmcplugin.addDirectoryItem(handle=handle, url=url, listitem=li, isFolder=True)

		#step 3: ...profit!
		else:
			xbmcgui.Dialog().ok('Planet.si', 'Invalid mode: '+str(mode))

		#write contents
		xbmcplugin.endOfDirectory(handle)

	except Exception as e:
		xbmcgui.Dialog().ok('RTVSlo.si', 'OMG, an error has occured?!\n'+e.message)
