from time import strptime, mktime, gmtime, strftime, localtime
from operator import itemgetter
import itertools
import sys, itertools, re, os, random, inspect
import copy
if sys.version_info < (2, 7):
    import simplejson
else:
    import json as simplejson
import xbmc, xbmcgui, xbmcaddon
# http://mail.python.org/pipermail/python-list/2009-June/596197.html
import _strptime
from threading import Thread
import aioupdate
from aioupdate import Uprandom

__addon__        = xbmcaddon.Addon()
__addonid__      = __addon__.getAddonInfo('id')
__addonversion__ = __addon__.getAddonInfo('version')
__settings__   = xbmcaddon.Addon(id='script.allinone')



def log(message):
    xbmc.log(msg=message)
class Main:
    def __init__( self ):
        log("iniciou o aiorecents")
        self._init_vars()
        self._fetch_info() 
        
    def _init_vars( self ):
        self.WINDOW = xbmcgui.Window( 10000 )          
        self.rctmovies = __settings__.getSetting("MoviesRecents")
        self.rctmoviesunwatched = __settings__.getSetting("MoviesRecentsHideWatched")
        self.rctepisodes = __settings__.getSetting("EpisodeRecents")
        self.rctepisodesfirst = __settings__.getSetting("EpisodeRecentsFirst")
        self.rctmusic = __settings__.getSetting("MusicRecents")
        self.rctconcerts = __settings__.getSetting("ConcertsRecents")
        self.LIMIT = 10
        log("terminou o aiorecents")
    def _fetch_info( self ):
        if self.rctmovies == 'false':
           self._clearproperties_moviesrecents()
           self._setproperties_moviesrecentslatest()
        if self.rctepisodes == 'false':
           self._clearproperties_episodesrecents()
           self._setproperties_episodesrecentslatest()
        if self.rctconcerts == 'false':
           self._clearproperties_musicvideosrecents()
           self._setproperties_musicvideosrecentslatest()
        if self.rctmusic == 'false' :
           self._clearproperties_songsrecents()
           self._clearproperties_albunsrecents
           self._setproperties_songsrecentslatest()
           self._setproperties_albunsrecentslatest()   
        if self.rctmovies == 'true':
           self._fetch_moviesrecents ()           
        if self.rctepisodes == 'true':
           self._fetch_episodesrecents()
        if self.rctconcerts == 'true':
           self._fetch_musicvideosrecents()
        if self.rctmusic == 'true':
           self._fetch_songsrecents()
           self._fetch_albunsrecents ()
        if self.rctmovies == 'true':
           self._clearproperties_moviesrecents()
           self._setproperties_moviesrecents()
        if self.rctepisodes == 'true':
           self._clearproperties_episodesrecents()
           self._setproperties_episodesrecents()
        if self.rctconcerts == 'true':
           self._clearproperties_musicvideosrecents()
           self._setproperties_musicvideosrecents()
        if self.rctmusic == 'true':
           self._clearproperties_songsrecents()
           self._clearproperties_albunsrecents()
           self._setproperties_songsrecents()
           self._setproperties_albunsrecents()
                     
    def _fetch_moviesrecents( self ):
        self.moviesrecents = []
        self.moviesrecentsall = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetRecentlyAddedMovies", "params": { "properties": ["title", "genre", "studio", "tagline", "runtime", "fanart", "thumbnail", "file", "plot", "plotoutline", "year", "lastplayed", "rating", "trailer", "playcount", "mpaa"] }, "id": 1}' )
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('movies'):
            for count, recentitem in enumerate(json_response['result']['movies']):
                    title = recentitem['title']
                    year = str(recentitem['year'])
                    genre = recentitem['genre']
                    studio = recentitem['studio']
                    plot = recentitem['plot']
                    plotoutline = recentitem['plotoutline']
                    tagline = recentitem['tagline']
                    runtime = str(recentitem['runtime'] / 60)
                    fanart = recentitem['fanart']
                    thumbnail = recentitem['thumbnail']
                    path = recentitem['file']
                    rating = str(round(float(recentitem['rating']),1))
                    trailer = recentitem['trailer']
                    mpaa = recentitem['mpaa']
                    if int(recentitem['playcount']) == 0:
                       self.moviesrecents.append([title, year, genre, studio, plot, plotoutline, tagline, runtime, fanart, thumbnail, path, rating, trailer, mpaa])
                    self.moviesrecentsall.append([title, year, genre, studio, plot, plotoutline, tagline, runtime, fanart, thumbnail, path, rating, trailer, mpaa])
        for index in range(len(self.moviesrecentsall)):
            xbmc.log(msg="fimes recents %s" % self.moviesrecentsall[index])

    def _fetch_seasonthumb( self, tvshowid, seasonnumber ):
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetSeasons", "params": {"properties": ["season", "thumbnail"], "tvshowid":%s }, "id": 1}' % tvshowid)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('seasons'):
            for item in json_response['result']['seasons']:
                season = "%.2d" % float(item['season'])
                if season == seasonnumber:
                    thumbnail = item['thumbnail']
                    xbmc.log(msg="retornou o thumbnail")
                    return thumbnail
    def _fetch_episodepercent( self, tvshowid, seasonnumber, episodenumber ):
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodes", "params": {"properties": ["episode", "season", "resume"], "tvshowid":%s }, "id": 1}' % tvshowid)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and json_response['result'].has_key('episodes'):
            for epipercent in json_response['result']['episodes']:
                season = "%.2d" % float(epipercent['season'])
                episode = "%.2d" % float(epipercent['episode'])
                if season == seasonnumber and episode == episodenumber:
                    try:
                       percentplayed = str(int(epipercent['resume']['position']*100) / int(epipercent['resume']['total']))
                       return percentplayed
                    except:
                       percentplayed = "0"
                       return percentplayed     
    def _fetch_episodesrecents( self ):
        self.episodesrecents = []
        self.episodesrecentsall = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetRecentlyAddedEpisodes", "params": {"properties": ["title", "playcount", "plot", "season", "episode", "showtitle", "thumbnail", "file", "lastplayed", "rating", "fanart", "tvshowid"] }, "id": 1}' )
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and json_response['result'].has_key('episodes'):
            for count,recentitem in enumerate(json_response['result']['episodes']):
                    title = recentitem['title']
                    episode = "%.2d" % float(recentitem['episode'])
                    path = recentitem['file']
                    plot = recentitem['plot']
                    season = "%.2d" % float(recentitem['season'])
                    thumb = recentitem['thumbnail']
                    showtitle = recentitem['showtitle']
                    rating = str(round(float(recentitem['rating']),1))
                    episodeno = "s%se%s" % ( season,  episode, )
                    fanart = recentitem['fanart']
                    tvshowid = recentitem['tvshowid']
                    seasonthumb = ''
                    if int(recentitem['playcount']) == 0:
                       self.episodesrecents.append([title, showtitle, season, episode, rating, plot, path, thumb, fanart, episodeno, seasonthumb, tvshowid])
                    self.episodesrecentsall.append([title, showtitle, season, episode, rating, plot, path, thumb, fanart, episodeno, seasonthumb, tvshowid])
        for count,episode in enumerate( self.episodesrecents ):
            count += 1
            tvshowid = episode[11]
            season = episode[2]
            episodenumber = episode[3]
            episode[10] = self._fetch_seasonthumb(tvshowid, season)
            if count == self.LIMIT:
                # stop here if our list contains more items
                break
        for count,episodeall in enumerate( self.episodesrecentsall ):
            count += 1
            tvshowid = episodeall[11]
            season = episodeall[2]
            episodenumber = episodeall[3]
            episodeall[10] = self._fetch_seasonthumb(tvshowid, season)
            if count == self.LIMIT:
                # stop here if our list contains more items
                break        
    
    def _fetch_musicvideosrecents( self ):
        self.musicvideosrecents = []
        self.musicvideosrecentsall = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetRecentlyAddedMusicVideos", "params": {"properties": ["title", "resume", "genre", "studio", "runtime", "fanart", "thumbnail", "file", "plot", "year", "lastplayed", "playcount"]}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and  json_response['result'].has_key('musicvideos'):
            for recentitem in json_response['result']['musicvideos']:
                    title = recentitem['title']
                    year = str(recentitem['year'])
                    genre = recentitem['genre']
                    studio = recentitem['studio']
                    plot = recentitem['plot']
                    runtime = str(recentitem['runtime'] / 60)
                    fanart = recentitem['fanart']
                    thumbnail = recentitem['thumbnail']
                    path = recentitem['file']
                    if recentitem.has_key('resume'):
                        # catch exceptions where the lastplayed isn't returned by json-rpc (bug?)
                        try:
                           percentplayed = str(int(recentitem['resume']['position']*100) / int(recentitem['resume']['total']))
                        except:
                           percentplayed = '0'
                        lastplayed = recentitem['lastplayed']
                    else:
                        lastplayed = ''
                    if lastplayed == '':
                        # catch exceptions where the item has been partially played, but playdate wasn't stored in the db
                        lastplayed = '0'
                    else:
                        datetime = strptime(lastplayed, "%Y-%m-%d %H:%M:%S")
                        lastplayed = str(mktime(datetime))
                    if int(recentitem['playcount']) == 0:
                       self.musicvideosrecents.append([title, year, genre, studio, plot, runtime, fanart, thumbnail, path, percentplayed, lastplayed])
                    self.musicvideosrecentsall.append([title, year, genre, studio, plot, runtime, fanart, thumbnail, path, percentplayed, lastplayed])                                                                      
           
    def _fetch_songsrecents( self ):
        self.songsrecents = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetRecentlyAddedSongs", "params": {"properties": ["title", "artist", "fanart", "thumbnail", "year", "genre", "file", "albumid"]}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and (json_response['result'] != None) and  (json_response['result'].has_key('songs')):
            for count,recentitem in enumerate(json_response['result']['songs']):
                    title = recentitem['title']
                    artist = recentitem['artist']
                    fanart = recentitem['fanart']
                    thumbnail = recentitem['thumbnail']
                    year = str(recentitem['year'])
                    genre = recentitem['genre']
                    countrecent = str(count)
                    path = recentitem['file']
                    albumid = str(recentitem['albumid'])
                    playlistpath = 'XBMC.RunScript(' + __addonid__ + ',songrecent=' + countrecent + ')'
                    self.songsrecents.append([title, artist, fanart, thumbnail, year, genre, countrecent, path, albumid])                 
                    if count == 200:
                       break
    def _fetch_albunsrecents( self ):
        self.albunsrecents = []
        repeatalbum = {}
        for count, albumsongs in enumerate( self.songsrecents ):
           json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetAlbumDetails", "params": {"properties": ["title", "artist", "fanart", "thumbnail", "year", "genre", "albumlabel"], "albumid":%s }, "id": 1}' % albumsongs[8])
           json_query = unicode(json_query, 'utf-8', errors='ignore')
           json_response = simplejson.loads(json_query)
           if json_response.has_key('result') and (json_response['result'] != None) and  (json_response['result'].has_key('albumdetails')):
                    recentitem = json_response['result']['albumdetails']
                    albumlabel = recentitem['albumlabel']
                    title = recentitem['title']
                    artist = recentitem['artist']
                    fanart = recentitem['fanart']
                    thumbnail = recentitem['thumbnail']
                    year = str(recentitem['year'])
                    genre = recentitem['genre']
                    albumid = albumsongs[8]
                    if albumid in repeatalbum:
                       continue
                    #path = recentitem['albumid']
                    repeatalbum[albumid] = 1
                    playlistpath = "musicdb://3/%s/" % albumid
                    #playlistpath = 'XBMC.RunScript(' + __addonid__ + ',albumid=' + albumid + ')'
                    self.albunsrecents.append([title, artist, fanart, thumbnail, year, genre, playlistpath, albumid ])                             
               
    def _setproperties_moviesrecents( self ):
        if (len(self.moviesrecents) > 0) and self.rctmoviesunwatched == 'true':
           listtouse = self.moviesrecents
        else:
           listtouse = self.moviesrecentsall
        for count, movie in enumerate( listtouse ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Title" % ( count ), movie[0] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Year" % ( count ), movie[1] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Genre" % ( count ), movie[2][0] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Studio" % ( count ), movie[3][0] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Plot" % ( count ), movie[4] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.PlotOutline" % ( count ), movie[5] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Tagline" % ( count ), movie[6] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.RunningTime" % ( count ), movie[7] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Fanart" % ( count ), movie[8] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Thumb" % ( count ), movie[9] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Path" % ( count ), movie[10] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Rating" % ( count ), movie[11] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Trailer" % ( count ), movie[12] )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.MPAA" % ( count ), movie[13] )
            if count == self.LIMIT:
               break
               
    def _setproperties_moviesrecentslatest( self ):
        count = 0        
        while count < self.LIMIT:
            count += 1
            Title = self.WINDOW.getProperty('LatestMovie.%d.Title' % count)
            Year = ""
            Genre = ""
            Studio = ""
            PlotOutline = ""
            Tagline = ""
            Plot = self.WINDOW.getProperty("LatestMovie.%d.Plot" % count )
            RunningTime = self.WINDOW.getProperty("LatestMovie.%d.RunningTime" % count)
            Fanart = self.WINDOW.getProperty("LatestMovie.%d.Fanart" % count)
            Thumb = self.WINDOW.getProperty("LatestMovie.%d.Thumb" % count)
            Path = self.WINDOW.getProperty("LatestMovie.%d.Path" % count)
            Rating = self.WINDOW.getProperty("LatestMovie.%d.Rating" % count)
            Trailer = self.WINDOW.getProperty("LatestMovie.%d.Trailer" % count)
            MPAA = ""
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Title" % ( count ), Title )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Year" % ( count ), Year )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Genre" % ( count ), Genre )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Studio" % ( count ), Studio )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Plot" % ( count ), Plot )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.PlotOutline" % ( count ), PlotOutline )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Tagline" % ( count ), Tagline )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.RunningTime" % ( count ), RunningTime )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Fanart" % ( count ), Fanart )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Thumb" % ( count ), Thumb )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Path" % ( count ), Path )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Rating" % ( count ), Rating )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.Trailer" % ( count ), Trailer )
            self.WINDOW.setProperty( "AllinOne_MovieRecents.%d.MPAA" % ( count ), MPAA ) 
                    
    def _setproperties_episodesrecents( self ):
        if len(self.episodesrecents) > 0:
           listtouse = self.episodesrecents
        else:
           listtouse = self.episodesrecentsall
        for count, episode in enumerate( listtouse ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Title" % ( count ), episode[0] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Episode" % ( count ), episode[3] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Season" % ( count ), episode[2] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Plot" % ( count ), episode[5] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.TVShowTitle" % ( count ), episode[1] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Path" % ( count ), episode[6] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Thumb" % ( count ), episode[7] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Fanart" % ( count ), episode[8] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.EpisodeNo" % ( count ), episode[9] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.SeasonThumb" % ( count ), episode[10] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Rating" % ( count ), episode[4] )
            xbmc.log(msg="episodes recents")                           
            if count == self.LIMIT:
               break
               
    def _setproperties_episodesrecentslatest( self ):
        count = 0        
        while count < self.LIMIT:
            count += 1
            EpisodeTitle = self.WINDOW.getProperty('LatestEpisode.%d.EpisodeTitle' % count)
            Episode = ""
            Season = ""
            Plot = self.WINDOW.getProperty('LatestEpisode.%d.Plot' % count)
            ShowTitle = self.WINDOW.getProperty('LatestEpisode.%d.ShowTitle' % count)
            Path = self.WINDOW.getProperty('LatestEpisode.%d.Path' % count)                        
            Thumb = self.WINDOW.getProperty('LatestEpisode.%d.Thumb' % count)
            Fanart = self.WINDOW.getProperty('LatestEpisode.%d.Fanart' % count)
            EpisodeNo = self.WINDOW.getProperty('LatestEpisode.%d.EpisodeNo' % count)
            SeasonThumb = ""
            Rating = self.WINDOW.getProperty('LatestEpisode.%d.Rating' % count)            
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Title" % ( count ), EpisodeTitle )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Episode" % ( count ), Episode )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Season" % ( count ), Season )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Plot" % ( count ), Plot )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.TVShowTitle" % ( count ), ShowTitle )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Path" % ( count ), Path )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Thumb" % ( count ), Thumb )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Fanart" % ( count ), Fanart )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.EpisodeNo" % ( count ), EpisodeNo )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.SeasonThumb" % ( count ), SeasonThumb )
            self.WINDOW.setProperty( "AllinOne_EpisodeRecents.%d.Rating" % ( count ), Rating )           
               
    def _setproperties_musicvideosrecents( self ):
        if len(self.musicvideosrecents) > 0:
           listtouse = self.musicvideosrecents
        else:
           listtouse = self.musicvideosrecentsall
        for count, musicvideo in enumerate( listtouse ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Title" % ( count ), musicvideo[0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Year" % ( count ), musicvideo[1] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Genre" % ( count ), musicvideo[2][0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Studio" % ( count ), musicvideo[3][0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Plot" % ( count ), musicvideo[4] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.RunningTime" % ( count ), musicvideo[5] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Fanart" % ( count ), musicvideo[6] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Thumb" % ( count ), musicvideo[7] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Path" % ( count ), musicvideo[8] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.PercentPlayed" % ( count ) , musicvideo[9] )
            if count == self.LIMIT:
               break
               
    def _setproperties_musicvideosrecentslatest( self ):                                 
        count = 0        
        while count < self.LIMIT:
            count += 1
            Title = self.WINDOW.getProperty('LatestMusicVideo.%d.Title' % count)
            Year = self.WINDOW.getProperty('LatestMusicVideo.%d.Year' % count)
            Genre = ""
            Studio = ""
            Plot = self.WINDOW.getProperty('LatestMusicVideo.%d.Plot' % count)
            RunningTime = self.WINDOW.getProperty('LatestMusicVideo.%d.RunningTime' % count)
            Fanart = self.WINDOW.getProperty('LatestMusicVideo.%d.Fanart' % count)
            Thumb = self.WINDOW.getProperty('LatestMusicVideo.%d.Thumb' % count)
            Path = self.WINDOW.getProperty('LatestMusicVideo.%d.Path' % count)
            PercentPlayed = ""
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Title" % ( count ), Title )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Year" % ( count ), Year )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Genre" % ( count ), Genre )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Studio" % ( count ), Studio )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Plot" % ( count ), Plot )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.RunningTime" % ( count ), RunningTime )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Fanart" % ( count ), Fanart )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Thumb" % ( count ), Thumb )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.Path" % ( count ), Path)
            self.WINDOW.setProperty( "AllinOne_MusicVideoRecents.%d.PercentPlayed" % ( count ) , PercentPlayed )
            
            
    def _setproperties_songsrecents( self ):
        for count, songs in enumerate( self.songsrecents ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Title" % ( count ), songs[0] )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Artist" % ( count ), songs[1][0] )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Genre" % ( count ), songs[5][0] )           
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Year" % ( count ), songs[4] )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Thumb" % ( count ), songs[3] )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Fanart" % ( count ), songs[2] )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Path" % ( count ), songs[7] )
            xbmc.log(msg="songs recents") 
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break 
    
    def _setproperties_songsrecentslatest( self ):
        count = 0
        while count < self.LIMIT:
            count += 1
            Title = self.WINDOW.getProperty('LatestSong.%d.Title' % count)
            Artist = self.WINDOW.getProperty('LatestSong.%d.Artist' % count)
            Genre = self.WINDOW.getProperty('LatestSong.%d.Genre' % count)
            Year = self.WINDOW.getProperty('LatestSong.%d.Year' % count)
            Thumb = self.WINDOW.getProperty('LatestSong.%d.Thumb' % count)
            Fanart = self.WINDOW.getProperty('LatestSong.%d.Fanart' % count)
            Path = self.WINDOW.getProperty('LatestSong.%d.Path' % count)                
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Title" % ( count ), Title )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Artist" % ( count ), Artist )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Genre" % ( count ), Genre)           
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Year" % ( count ), Year )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Thumb" % ( count ), Thumb )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Fanart" % ( count ), Fanart )
            self.WINDOW.setProperty( "AllinOne_SongRecents.%d.Path" % ( count ), Path )
                
    def _setproperties_albunsrecents( self ):
        for count, album in enumerate( self.albunsrecents ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Title" % ( count ), album[0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Artist" % ( count ), album[1][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Genre" % ( count ), album[5][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Year" % ( count ), album[4] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Thumb" % ( count ), album[3] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Fanart" % ( count ), album[2] )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Path" % ( count ), album[6] )
            xbmc.log(msg="albuns recents") 
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break                                                             
    
    def _setproperties_albunsrecentslatest( self ):
        count = 0
        while count < self.LIMIT:
            count += 1
            Title = self.WINDOW.getProperty('LatestAlbum.%d.Title' % count)
            Artist = self.WINDOW.getProperty('LatestAlbum.%d.Artist' % count)
            Genre = self.WINDOW.getProperty('LatestAlbum.%d.Genre' % count)
            Year = self.WINDOW.getProperty('LatestAlbum.%d.Year' % count)
            Thumb = self.WINDOW.getProperty('LatestAlbum.%d.Thumb' % count)
            Fanart = self.WINDOW.getProperty('LatestAlbum.%d.Fanart' % count)
            Path = self.WINDOW.getProperty('LatestAlbum.%d.Path' % count)
            xbmc.log(msg=Path)
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Title" % ( count ), Title)
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Artist" % ( count ), Artist )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Genre" % ( count ), Genre )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Year" % ( count ), Year )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Thumb" % ( count ), Thumb )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Fanart" % ( count ), Fanart )
            self.WINDOW.setProperty( "AllinOne_AlbumRecents.%d.Path" % ( count ), Path )

    def _clearproperties_moviesrecents( self ):
        for count in range (self.LIMIT):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MovieRecents.%d.Title" % ( count ) )           
            
    def _clearproperties_episodesrecents( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_EpisodeRecents.%d.Title" % ( count ) )
            
    def _clearproperties_musicvideosrecents( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MusicVideoRecents.%d.Title" % ( count ) )                                               
    
    def _clearproperties_songsrecents( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_SongRecents.%d.Title" % ( count ) )
    
    def _clearproperties_albunsrecents( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_AlbumRecents.%d.Title" % ( count ) )           
          
class fetchrecents(Thread):
    def __init__ (self, fetchrecent, clearrecent, setrecent):
        self.fetchrecent = fetchrecent
        self.clearrecent = clearrecent
        self.setrecent = setrecent 
        Thread.__init__(self)
    def run(self):
        self.fetchrecent()
        self.clearrecent()
        self.setrecent()
                                              
if ( __name__ == "__main__" ):
    log('script version %s started' % __addonversion__)
    Main()      