from time import strptime, mktime, gmtime, strftime, localtime
from operator import itemgetter
import itertools
import sys, itertools, re, os, random, inspect
import copy
if sys.version_info < (2, 7):
    import simplejson
else:
    import json as simplejson
import xbmc, xbmcgui, xbmcaddon
# http://mail.python.org/pipermail/python-list/2009-June/596197.html
import _strptime
from threading import Thread
import aioupdate
import aiorecents
from aioupdate import Uprandom

__addon__        = xbmcaddon.Addon()
__addonid__      = __addon__.getAddonInfo('id')
__addonversion__ = __addon__.getAddonInfo('version')
__settings__   = xbmcaddon.Addon(id='script.allinone')



def log(message):
    xbmc.log(msg=message)
class Main:
    def __init__( self ):
        log("iniciou o allinone")        
        self._parse_argv()
        self._firstrun()
        if self.PLAYLISTEPISODE or self.UPALLINONE:
           self._actionaio()
        elif self.ALBUMID:
            self._play_album( self.ALBUMID )
        else:
           self._init_vars()
           x= self.WINDOW.getProperty('LatestEpisode.4.EpisodeTitle')
           xbmc.log(msg=x)
           self.WINDOW.clearProperty('AllInOne_Running')
           self._fetch_info()
           self.WINDOW.setProperty('AllInOne_UpRandom', '1')
           xbmc.sleep(2000)
           self.WINDOW.setProperty('AllInOne_Running', 'True')
           self._daemon()
    def _parse_argv( self ):
        #get all params send from skinner
        try:
            params = dict( arg.split( "=" ) for arg in sys.argv[ 1 ].split( "&" ) )
        except:
            params = {}
        self.MOVIESRANDOMGET = params.get( "moviesrandomget", "" )
        self.MOVIES =  __settings__.getSetting("MovieProgress")
        self.MOVIESRANDOM = __settings__.getSetting("MovieRandom")
        self.EPISODES = __settings__.getSetting("EpisodeProgress")
        self.EPISODESRANDOM = __settings__.getSetting("EpisodeRandom")
        self.EPISODESRANDOMTYPE = __settings__.getSetting("TypeEpisodeRandom")
        self.EPISODESRANDOMGET = params.get( "episodesrandomget", "" )
        self.MUSICVIDEOS = __settings__.getSetting("ConcertsRandom")
        self.MUSICVIDEOSRANDOMGET = params.get("musicvideosrandomget", "")
        self.MUSICRANDOMGET = params.get("musicrandomget", "") 
        self.LIMIT = 10
        self.PLAYLISTEPISODE = params.get("playlistepisode", "")
        self.UPALLINONE = params.get('upallinone','')
        self.ALBUMS = __settings__.getSetting("MusicProgress")
        self.ALBUMSRANDOM = __settings__.getSetting("MusicRandom")
        self.ALBUMID = params.get( "albumid", "" )
        self.RECENTS = params.get("recents", "")
        self.RECENTSUPDATE = params.get("recentsupdate", "")
        self.EPISODEBARHIDE = __settings__.getSetting("EpisodeBarHide")
        
    def _firstrun(self): 
        if ( not xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandom')):
           estadoupdateinicial = xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandom')
           xbmc.log(msg="uprandom inicial igual  a %s" % estadoupdateinicial)
           xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandom', '0')
        if self.RECENTS == 'true':   
           aiorecents.Main()
           #t = callfetchrecents()
           #t.start()
           #t.join()
           
    def _actionaio( self ):
        if self.UPALLINONE:
           if xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandom') == '1':
              buttonid = str(xbmcgui.Window( 10000 ).getFocusId())
              xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandomButtonId', buttonid)
              if self.MOVIESRANDOMGET == 'true':
                 xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandomMovies', '1')
                 xbmc.log(msg="passou no random upallinone movies")
              else:
                 xbmcgui.Window( 10000 ).clearProperty('AllInOne_UpRandomMovies')
              if self.EPISODESRANDOMGET == 'true':
                 xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandomEpisodes', '1')
              else:
                 xbmcgui.Window( 10000 ).clearProperty('AllInOne_UpRandomEpisodes')
              if self.MUSICVIDEOSRANDOMGET == 'true':
                 xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandomMusicVideos', '1')
              else:
                 xbmcgui.Window( 10000 ).clearProperty('AllInOne_UpRandomMusicVideos')
              if self.MUSICRANDOMGET == 'true':
                 xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandomMusic', '1')
              else:
                 xbmcgui.Window( 10000 ).clearProperty('AllInOne_UpRandomMusic')
              xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandom', '2')
              xbmc.sleep(900)
              xbmcgui.Window( 10000 ).setProperty('AllInOne_UpRandom', '1')  
        
    def _init_vars( self ):
        self.WINDOW = xbmcgui.Window( 10000 )          
        self.Player = MyPlayer( action = self._update, movies = ( self.MOVIES == 'true' ), episodes = ( self.EPISODES == 'true' ), albums = ( self.ALBUMS == 'true' ))
        #self.Uprandom = UpdateRandom(upaction = self._fetch_randomup)   
        
    def _fetch_info( self ):         
        if self.MOVIES == 'true' or self.MOVIESRANDOM == 'true':
            self._fetch_movies()
            if self.MOVIES == 'true':
               self._fetch_moviesprogress()
            if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.MOVIESRANDOM == 'true':
               self._fetch_moviesrandom()                      
        if self.MOVIES == 'true':            
            self._clearproperties_moviesprogress()
            self._setproperties_moviesprogress()
        if self.MOVIES == 'false':
            self._clearproperties_moviesprogress()        
        if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.MOVIESRANDOM == 'true':
            self._clearproperties_moviesrandom()
            self._setproperties_moviesrandom()
        if self.MOVIESRANDOM == 'false':
            self._clearproperties_moviesrandom()        
        if self.EPISODES == 'true' or self.EPISODESRANDOM == 'true':                       
            self._fetch_tvshows()
            if self.EPISODES == 'true' or self.EPISODESRANDOMTYPE == 'INPROGRESS':
               self._fetch_episodes()
            if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.EPISODESRANDOM == 'true':
               if self.EPISODESRANDOMTYPE == 'ALL':
                  self._fetch_episodesrandom()
               if self.EPISODESRANDOMTYPE == 'INPROGRESS':
                  self._fetch_episodesrandomprogress()
        if self.EPISODES == 'true':
            self._clearproperties_episodesprogress()
            self._setproperties_episodesprogress()
        if self.EPISODES == 'false':
            self._clearproperties_episodesprogress()
        if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.EPISODESRANDOM == 'true':
            self._clearproperties_episodesrandom()
            self._setproperties_episodesrandom()
        if self.EPISODESRANDOM == 'false':
            self._clearproperties_episodesrandom()     
        if self.MUSICVIDEOS == 'true':
            self._fetch_musicvideos()
            if self.WINDOW.getProperty('AllInOne_UpRandom') == "0":
               self._fetch_musicvideosrandom()  
        if self.MUSICVIDEOS == 'true':
            if self.WINDOW.getProperty('AllInOne_UpRandom') == "0":
               self._clearproperties_musicvideosrandom()
               self._setproperties_musicvideosrandom()
        if self.MUSICVIDEOS == 'false':
            self._clearproperties_musicvideosrandom()
        if self.ALBUMS == 'true' or self.ALBUMSRANDOM == 'true':
            self._fetch_songsbase()
            if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.ALBUMSRANDOM == 'true':
               self._fetch_songsrandom()
               self._fetch_albunsrandom()
            self._fetch_songs()
            self._fetch_albums()
        if self.ALBUMS == 'true':
            self._clearproperties_albumprogress()
            self._setproperties_albumprogress()
        if self.ALBUMS == 'false':
            self._clearproperties_albumprogress()
        if self.WINDOW.getProperty('AllInOne_UpRandom') == "0" and self.ALBUMSRANDOM == 'true':
            self._clearproperties_albunsrandom()
            self._clearproperties_songsrandom()
            self._setproperties_songsrandom()
            self._setproperties_albunsrandom()
        if self.ALBUMSRANDOM == 'false':
            self._clearproperties_albunsrandom()            
            self._clearproperties_songsrandom()
               
    def _fetch_randomup(self):
         if xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandomMovies')== '1':
            self._fetch_moviesrandom()
            self._clearproperties_moviesrandom()                                
            self._setproperties_moviesrandom()
         if xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandomEpisodes')== '1':
            if self.EPISODESRANDOMTYPE == 'ALL':
               self._fetch_episodesrandom()
            if self.EPISODESRANDOMTYPE == 'INPROGRESS':
               self._fetch_episodesrandomprogress()
            self._clearproperties_episodesrandom()
            self._setproperties_episodesrandom()
         if xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandomMusicVideos')== '1':
            self._fetch_musicvideosrandom()
            self._clearproperties_musicvideosrandom()
            self._setproperties_musicvideosrandom()
         if xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandomMusic')== '1':
            self._fetch_songsrandom()
            self._fetch_albunsrandom()
            self._clearproperties_albunsrandom()
            self._clearproperties_songsrandom()
            self._setproperties_songsrandom()
            self._setproperties_albunsrandom()  
         
    def _fetch_movies( self ):
        self.movies = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetMovies", "params": {"properties": ["title", "resume", "genre", "studio", "tagline", "runtime", "fanart", "thumbnail", "file", "plot", "plotoutline", "year", "lastplayed", "rating", "trailer", "mpaa"]}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('movies'):
            for item in json_response['result']['movies']:
                    title = item['title']
                    year = str(item['year'])
                    genre = item['genre']
                    studio = item['studio']
                    plot = item['plot']
                    plotoutline = item['plotoutline']
                    tagline = item['tagline']
                    runtime = str(item['runtime'] / 60)
                    fanart = item['fanart']
                    thumbnail = item['thumbnail']
                    path = item['file']
                    rating = str(round(float(item['rating']),1))
                    trailer = item['trailer']
                    mpaa = item['mpaa']
                    resumeposition = str(int(item['resume']['position']))
                    if item.has_key('resume') and item['resume']['position'] > 0:
                        percentplayed = str(int(item['resume']['position']*100) / int(item['resume']['total']))
                    else:
                        percentplayed = "0"
                    if item.has_key('resume'):
                        # catch exceptions where the lastplayed isn't returned by json-rpc (bug?)
                        lastplayed = item['lastplayed']
                    else:
                        lastplayed = ''
                    if lastplayed == '':
                        # catch exceptions where the item has been partially played, but playdate wasn't stored in the db
                        lastplayed = '0'
                    else:
                        datetime = strptime(lastplayed, "%Y-%m-%d %H:%M:%S")
                        lastplayed = str(mktime(datetime))
                    self.movies.append([title, year, genre, studio, plot, plotoutline, tagline, runtime, fanart, thumbnail, path, rating, lastplayed, percentplayed, trailer, resumeposition, mpaa])
        xbmc.log(msg="xxxxxxxxxxxxxxxxxx terminou de preencher os filmesxxxxxxxxxxxxxxxxxxxxxxxxx")
    def _fetch_moviesrandom( self ):
        self.moviesrandombase = list(self.movies)
        self.moviesrandomlist = []
        count = 0
        while count < self.LIMIT:
              if len(self.moviesrandombase) == 0:
                 break
              count += 1
              randomitem = random.choice( self.moviesrandombase )
              title = randomitem[0]
              year = randomitem[1]
              genre = randomitem[2]
              studio = randomitem[3]
              plot = randomitem[4]
              plotoutline = randomitem[5]
              tagline = randomitem[6]
              runtime = randomitem[7]
              fanart = randomitem[8]
              thumbnail = randomitem[9]
              path = randomitem[10]
              rating = randomitem[11]
              lastplayed = randomitem[12]
              percentplayed = randomitem[13]
              trailer = randomitem[14]
              mpaa = randomitem[16]
              self.moviesrandomlist.append([title, year, genre, studio, plot, plotoutline, tagline, runtime, fanart, thumbnail, path, rating, percentplayed, trailer, lastplayed, mpaa])
              self.moviesrandombase.remove(randomitem)
        self._clearproperties_moviesrandom()
        self._setproperties_moviesrandom()

    def _fetch_moviesprogress( self ):
       self.moviesprogress = self.movies
       self.moviesprogresslist = []
       for itemprogress in self.moviesprogress:
           if int(itemprogress[15]) > 0:
              title = itemprogress[0]
              year = itemprogress[1]
              genre = itemprogress[2]
              studio = itemprogress[3]
              plot = itemprogress[4]
              plotoutline = itemprogress[5]
              tagline = itemprogress[6]
              runtime = itemprogress[7]
              fanart = itemprogress[8]
              thumbnail = itemprogress[9]
              path = itemprogress[10]
              rating = itemprogress[11]
              lastplayed = itemprogress[12]
              percentplayed = itemprogress[13]
              trailer = itemprogress[14]
              mpaa = itemprogress[16]
              self.moviesprogresslist.append([lastplayed, title, year, genre, studio, plot, plotoutline, tagline, runtime, fanart, thumbnail, path, rating, percentplayed, trailer, mpaa])
              self.moviesprogresslist.sort(reverse = True)
           
    def _fetch_tvshows( self ):
        self.tvshows = []
        self.episodesrandombase = []
        # fetch all episodes in one query
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodes", "params": {"properties": ["title", "playcount", "plot", "season", "episode", "showtitle", "file", "lastplayed", "rating", "tvshowid"], "sort": {"method": "episode"} }, "id": 1}' )
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('episodes'):
            json_response = json_response['result']['episodes']
            # our list is sorted by episode number, secondary we sort by tvshow title (itertools.groupy needs contiguous items) and split it into seperate lists for each tvshow
            episodes = [list(group) for key,group in itertools.groupby(sorted(json_response, key=itemgetter('showtitle')), key=itemgetter('showtitle'))]
            self.episodesrandombase = list(json_response)
        # fetch all tvshows, sorted by title
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetTVShows", "params": {"properties": ["title", "studio", "thumbnail", "fanart"], "sort": {"method": "title"}}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('tvshows'):
            for count, tvshow in enumerate(json_response['result']['tvshows']):
                item = [tvshow['tvshowid'], tvshow['thumbnail'], tvshow['studio'], tvshow['title'], tvshow['fanart'], []]
                for episodelist in episodes:
                    if episodelist[0]['showtitle'] == item[3]:
                        item[5] = episodelist
                        break
                self.tvshows.append(item)

    def _fetch_seasonthumb( self, tvshowid, seasonnumber ):
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetSeasons", "params": {"properties": ["season", "thumbnail"], "tvshowid":%s }, "id": 1}' % tvshowid)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'].has_key('seasons'):
            for item in json_response['result']['seasons']:
                season = "%.2d" % float(item['season'])
                if season == seasonnumber:
                    thumbnail = item['thumbnail']
                    xbmc.log(msg="retornou o thumbnail")
                    return thumbnail
                    
    def _fetch_episodepercent( self, tvshowid, seasonnumber, episodenumber ):
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodes", "params": {"properties": ["episode", "season", "resume"], "tvshowid":%s }, "id": 1}' % tvshowid)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and json_response['result'].has_key('episodes'):
            for epipercent in json_response['result']['episodes']:
                season = "%.2d" % float(epipercent['season'])
                episode = "%.2d" % float(epipercent['episode'])
                if season == seasonnumber and episode == episodenumber:
                    try:
                       percentplayed = str(int(epipercent['resume']['position']*100) / int(epipercent['resume']['total']))
                       return percentplayed
                    except:
                       percentplayed = "0"
                       return percentplayed
                       
    def _fetch_episodethumb( self, tvshowid, seasonnumber, episodenumber,): 
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodes", "params": {"properties": ["episode", "season", "thumbnail"], "tvshowid":%s }, "id": 1}' % tvshowid)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and json_response['result'].has_key('episodes'):
            for image in json_response['result']['episodes']:
                season = "%.2d" % float(image['season'])
                episode = "%.2d" % float(image['episode'])
                if season == seasonnumber and episode == episodenumber:                   
                   thumbnail = image['thumbnail']
                   xbmc.log(msg="retornou o EPISODE thumbnail")
                   return  thumbnail                  

    def _fetch_episodes( self ):
        self.episodes = []
        self.eprandomprgbase = []
        for tvshow in self.tvshows:
            lastplayed = ""
            episode_sorter = lambda item: (int(item['season']), int(item['episode']))
            for key, group in itertools.groupby(sorted(tvshow[5], key=episode_sorter), episode_sorter):
                playcount = 0
                for item in sorted(group, key=lambda x: (x['lastplayed'], x['episodeid'])):
                    # sort first by lastplayed, so we're certain to always get the latest played item upon final iteration of the loop. Then sort by episodeid, mainly for the case where lastplayed is empty for all items, and we want the latest episodeid to be the one chosen (higher episodeid equals being added later to xbmc)
                    playcount += int(item['playcount'])
                if playcount != 0:
                    # this episode has been watched, record play date (we need it for sorting the final list) and continue to next episode
                    lastplayed = item['lastplayed']
                    if lastplayed == '':
                        # catch exceptions where the episode has been played, but playdate wasn't stored in the db
                        lastplayed = '0'
                    else:
                        datetime = strptime(lastplayed, "%Y-%m-%d %H:%M:%S")
                        lastplayed = str(mktime(datetime))
                    continue
                else:
                    # this is the first unwatched episode, check if the episode is partially watched
                    playdate = item['lastplayed']
                    if (lastplayed == "") and (playdate == ""):
                        # it's a tv show with 0 watched episodes, continue to the next tv show
                        break
                    else:
                        # this is the episode we need
                        title = item['title']
                        episode = "%.2d" % float(item['episode'])
                        path = item['file']
                        plot = item['plot']
                        season = "%.2d" % float(item['season'])
                        thumbnail = ''
                        showtitle = item['showtitle']
                        rating = str(round(float(item['rating']),1))
                        episodeno = "s%se%s" % ( season,  episode, )
                        if not playdate == '':
                            # if the episode is partially watched, use it's playdate for sorting
                            datetime = strptime(playdate, "%Y-%m-%d %H:%M:%S")
                            lastplayed = str(mktime(datetime))
                            resumable = "True"
                        else:
                            resumable = "False"
                        tvshowid = tvshow[0]
                        showthumb = tvshow[1]
                        studio = tvshow[2]
                        fanart = tvshow[4]
                        seasonthumb = ''
                        percentplayed = '0'
                        self.episodes.append([lastplayed, title, episode, season, plot, showtitle, path, thumbnail, fanart, episodeno, studio, showthumb, seasonthumb, resumable, rating, playcount, tvshowid, percentplayed])
                        # we have found our episode, collected all data, so continue to next tv show
                        break
        self.episodes.sort(reverse=True)
        self.eprandomprgbase = list(self.episodes)
        # only fetch seasonthumbs for items that will actually show up in the skin
        for count, episode in enumerate( self.episodes ):
            count += 1
            tvshowid = episode[16]
            season = episode[3]
            episodenumber = episode[2]
            episode[12] = self._fetch_seasonthumb(tvshowid, season)
            if self.EPISODEBARHIDE == 'false':
               episode[17] = self._fetch_episodepercent(tvshowid, season, episodenumber)
            episode[7] = self._fetch_episodethumb(tvshowid, season, episodenumber)
            teste1 = str(episode[17])
            if count == 10:
                # stop here if our list contains more items
                break
        log("episode list: %s items" % len(self.episodes)) 
        
    def _fetch_episodesrandom( self ):
        self.episodesrandomlistbase = list(self.eprandomprgbase)
        self.episodesrandomlist = []  
        count = 0
        while count < self.LIMIT:
             if len(self.episodesrandomlistbase) == 0:
                return
             count += 1
             randomitem = random.choice( self.episodesrandomlistbase )
             title = randomitem['title']
             showtitle = randomitem['showtitle']
             season = "%.2d" % float(randomitem['season'])
             episode = "%.2d" % float(randomitem['episode'])
             rating = str(round(float(randomitem['rating']),1))
             plot = randomitem['plot']
             path = randomitem['file']
             thumb =''
             fanart = ''
             episodeno = "s%se%s" % ( season,  episode, )
             tvshowid = randomitem['tvshowid']
             seasonthumb = ''
             self.episodesrandomlist.append([title, showtitle, season, episode, rating, plot, path, thumb, fanart, episodeno, seasonthumb, tvshowid])
             self.episodesrandomlistbase.remove(randomitem)
        for count, episode in enumerate( self.episodesrandomlist ):
            count += 1
            tvshowid = episode[11]
            season = episode[2]
            episodenumber = episode[3]
            episode[10] = self._fetch_seasonthumb(tvshowid, season)
            episode[7] = self._fetch_episodethumb(tvshowid, season, episodenumber)            
            if count == 10:
                # stop here if our list contains more items
                break     
    
    def _fetch_episodesrandomprogress( self ):
        self.episodesrandomlistbase = list(self.eprandomprgbase)
        self.episodesrandomlist = []  
        count = 0
        while count < self.LIMIT:
             if len(self.episodesrandomlistbase) == 0:
                return
             count += 1
             randomitem = random.choice( self.episodesrandomlistbase )
             title = randomitem[1]
             showtitle = randomitem[5]
             season = randomitem[3]
             episode = randomitem[2]
             rating = randomitem[14]
             plot = randomitem[4]
             path = randomitem[6]
             thumb =''
             fanart = randomitem[8]
             episodeno = randomitem[9]
             tvshowid = randomitem[16]
             seasonthumb = ''
             self.episodesrandomlist.append([title, showtitle, season, episode, rating, plot, path, thumb, fanart, episodeno, seasonthumb, tvshowid])
             self.episodesrandomlistbase.remove(randomitem)
#0lastplayed, 1title, 2episode, 3season, 4plot, 5showtitle, 6path, 7thumbnail, 8fanart, 9episodeno, 10studio, 11showthumb, 12seasonthumb, 13resumable, 14rating, 15playcount, 16tvshowid, 17percentplayed]
        for count, episode in enumerate( self.episodesrandomlist ):
            count += 1
            tvshowid = episode[11]
            season = episode[2]
            episodenumber = episode[3]
            episode[10] = self._fetch_seasonthumb(tvshowid, season)
            episode[7] = self._fetch_episodethumb(tvshowid, season, episodenumber)            
            if count == 10:
                # stop here if our list contains more items
                break
                
    def _fetch_musicvideos( self ):
        self.musicvideos = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetMusicVideos", "params": {"properties": ["title", "resume", "genre", "studio", "runtime", "fanart", "thumbnail", "file", "plot", "year", "lastplayed", "playcount"]}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and json_response['result'] != None and json_response['result'].has_key('musicvideos'):
            for item in json_response['result']['musicvideos']:
                    title = item['title']
                    year = str(item['year'])
                    genre = item['genre']
                    studio = item['studio']
                    plot = item['plot']
                    runtime = str(item['runtime'] / 60)
                    fanart = item['fanart']
                    thumbnail = item['thumbnail']
                    path = item['file']
                    resumeposition = str(int(item['resume']['position']))
                    if item.has_key('resume') and item['resume']['position'] > 0:
                        percentplayed = str(int(item['resume']['position']*100) / int(item['resume']['total']))
                    else:
                        percentplayed = "0"
                    if item.has_key('resume'):
                        # catch exceptions where the lastplayed isn't returned by json-rpc (bug?)
                        lastplayed = item['lastplayed']
                    else:
                        lastplayed = ''
                    if lastplayed == '':
                        # catch exceptions where the item has been partially played, but playdate wasn't stored in the db
                        lastplayed = '0'
                    else:
                        datetime = strptime(lastplayed, "%Y-%m-%d %H:%M:%S")
                        lastplayed = str(mktime(datetime))
                    self.musicvideos.append([title, year, genre, studio, plot, runtime, fanart, thumbnail, path, lastplayed, percentplayed, resumeposition])       

    def _fetch_musicvideosrandom( self ):
        self.musicvideosrandombase = list(self.musicvideos)
        self.musicvideosrandomlist = []
        count = 0
        while count < self.LIMIT:
              if len(self.musicvideosrandombase) == 0:
                 break
              count += 1
              randomitem = random.choice( self.musicvideosrandombase )
              title = randomitem[0]
              year = randomitem[1]
              genre = randomitem[2]
              studio = randomitem[3]
              plot = randomitem[4]
              runtime = randomitem[5]
              fanart = randomitem[6]
              thumbnail = randomitem[7]
              path = randomitem[8]
              lastplayed = randomitem[9]
              percentplayed = randomitem[10]
              self.musicvideosrandomlist.append([title, year, genre, studio, plot, runtime, fanart, thumbnail, path, percentplayed, lastplayed])
              self.musicvideosrandombase.remove(randomitem)         
           
    def _fetch_songsbase( self ):
        self.songsbase = []
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetSongs", "params": {"properties": ["title", "artist", "fanart", "thumbnail", "year", "genre", "file", "albumid"]}, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and (json_response['result'] != None) and  (json_response['result'].has_key('songs')):
            for item in json_response['result']['songs']:
                  title = item['title']
                  artist = item['artist']
                  fanart = item['fanart']
                  thumbnail = item['thumbnail']
                  year = str(item['year'])
                  genre = item['genre']
                  path = item['file']
                  albumid = str(item['albumid'])
                  countrandom = ""
                  self.songsbase.append([title, artist, fanart, thumbnail, year, genre, countrandom, path, albumid])
                  
    def _fetch_songsrandom( self ):
        self.songsrandombase = list(self.songsbase)
        self.songsrandomlist = []
        repeatalbum = {}
        count = 0
        while count < self.LIMIT:
              if len(self.songsrandombase) == 0:
                 break
              count += 1
              randomitem = random.choice( self.songsrandombase )
              title = randomitem[0]
              artist = randomitem[1]
              fanart = randomitem[2]
              thumbnail = randomitem[3]
              year = str(randomitem[4])
              genre = randomitem[5]
              countrandom = str(count)
              path = randomitem[7]
              albumid = str(randomitem[8])
              if albumid in repeatalbum:
                 self.songsrandombase.remove(randomitem)
                 count  -= 1
                 continue
              repeatalbum[albumid] = 1
              self.songsrandomlist.append([title, artist, fanart, thumbnail, year, genre, countrandom, path, albumid])
              self.songsrandombase.remove(randomitem)
              
    def _fetch_albunsrandom( self ):
        self.albunsrandom = []
        for count, albumsongs in enumerate( self.songsrandomlist ):
           json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetAlbumDetails", "params": {"properties": ["title", "artist", "fanart", "thumbnail", "year", "genre", "albumlabel"], "albumid":%s }, "id": 1}' % albumsongs[8])
           json_query = unicode(json_query, 'utf-8', errors='ignore')
           json_response = simplejson.loads(json_query)
           if json_response.has_key('result') and (json_response['result'] != None) and  (json_response['result'].has_key('albumdetails')):
                    randomitem = json_response['result']['albumdetails']
                    albumlabel = randomitem['albumlabel']
                    title = randomitem['title']
                    artist = randomitem['artist']
                    fanart = randomitem['fanart']
                    thumbnail = randomitem['thumbnail']
                    year = str(randomitem['year'])
                    genre = randomitem['genre']
                    albumid = albumsongs[8]
                    playlistpath = "musicdb://3/%s/" % albumid
                    #playlistpath = 'XBMC.RunScript(' + __addonid__ + ',albumid=' + albumid + ')'
                    self.albunsrandom.append([title, artist, fanart, thumbnail, year, genre, playlistpath, albumid ])                                                                       
                             
    def _fetch_songs( self ):
        self.albumsids = {}
        previousid = ''
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetSongs", "params": {"properties": ["playcount", "albumid"], "sort": { "method": "album" } }, "id": 1}')
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        if json_response.has_key('result') and (json_response['result'] != None) and (json_response['result'].has_key('songs')):
            for item in json_response['result']['songs']:
                albumid = item['albumid']
                if albumid != '':
                    # ignore single tracks that do not belong to an album
                    if albumid != previousid:
                        # new album
                        albumplaycount = 0
                        playcount = item['playcount']
                        albumplaycount = albumplaycount + playcount
                        previousid = albumid
                    else:
                        # song from the same album
                        playcount = item['playcount']
                        albumplaycount = albumplaycount + playcount
                    if playcount != 0:
                        # don't add unplayed items
                        self.albumsids.update({albumid: albumplaycount})
        self.albumsids = sorted(self.albumsids.items(), key=itemgetter(1))
        self.albumsids.reverse()

    def _fetch_albums( self ):
        self.albums = []
        for count, albumid in enumerate( self.albumsids ):
            count += 1
            json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetAlbumDetails", "params": {"properties": ["title", "description", "albumlabel", "artist", "genre", "year", "thumbnail", "fanart", "rating"], "albumid":%s }, "id": 1}' % albumid[0])
            json_query = unicode(json_query, 'utf-8', errors='ignore')
            json_response = simplejson.loads(json_query)
            if json_response.has_key('result') and (json_response['result'] != None) and json_response['result'].has_key('albumdetails'):
                item = json_response['result']['albumdetails']
                description = item['description']
                album = item['title']
                albumlabel = item['albumlabel']
                artist = item['artist']
                genre = item['genre']
                year = str(item['year'])
                thumbnail = item['thumbnail']
                fanart = item['fanart']
                rating = str(item['rating'])
                stralbumid = str(albumid[0])
                if rating == '48':
                    rating = ''
                path = "musicdb://3/%s/" % stralbumid    
                #path = 'XBMC.RunScript(' + __addonid__ + ',albumid=' + str(albumid[0]) + ')'
                self.albums.append((album, artist, genre, year, albumlabel, description, rating, thumbnail, fanart, path))
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break                

    def _play_album( self, ID ):
        json_query = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "AudioLibrary.GetSongs", "params": {"properties": ["file", "fanart", "thumbnail"], "albumid":%s }, "id": 1}' % ID)
        json_query = unicode(json_query, 'utf-8', errors='ignore')
        json_response = simplejson.loads(json_query)
        # create a playlist
        playlist = xbmc.PlayList(0)
        # clear the playlist
        playlist.clear()
        if json_response.has_key('result') and json_response['result'].has_key('songs'):
            for item in json_response['result']['songs']:
                song = item['file']
                fanart = item['fanart']
                thumbnail= item['thumbnail']
                # create playlist item
                listitem = xbmcgui.ListItem()
                # add fanart image to the playlist item
                listitem.setProperty( "fanart_image", fanart )
                # add item to the playlist
                playlist.add( url=song, listitem=listitem )
            # play the playlist
            xbmc.Player().play( playlist )

    def _daemon( self ):
        # keep running until xbmc exits or another instance is started
        while (not xbmc.abortRequested) and self.WINDOW.getProperty('AllInOne_Running') == 'True':
            buttonid = xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandomButtonId')
            buttonget = str(xbmcgui.Window( 10000 ).getFocusId())            
            if buttonid == buttonget and xbmcgui.Window( 10000 ).getProperty('AllInOne_UpRandom') == "2":
               self._fetch_randomup()
            if xbmc.getCondVisibility('Library.IsScanningMusic') or xbmc.getCondVisibility('Library.IsScanningVideo') :
               while xbmc.getCondVisibility('Window.IsVisible(10112)') or xbmc.getCondVisibility('Window.IsVisible(10133)'):
                    xbmc.sleep(500)
               aiorecents.Main()
            xbmc.sleep(1000)
        if xbmc.abortRequested:
            log('script stopped: xbmc quit')
        else:
            log('script stopped: new script instance started')           
           
    def _setproperties_moviesrandom( self ):
        for count, movie in enumerate( self.moviesrandomlist ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Title" % ( count ), movie[0] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Year" % ( count ), movie[1] )        
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Genre" % ( count ), movie[2][0] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Studio" % ( count ), movie[3][0] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Plot" % ( count ), movie[4] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.PlotOutline" % ( count ), movie[5] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Tagline" % ( count ), movie[6] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.RunningTime" % ( count ), movie[7] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Fanart" % ( count ), movie[8] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Thumb" % ( count ), movie[9] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Path" % ( count ), movie[10] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Rating" % ( count ), movie[11] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.PercentPlayed" % ( count ), movie[12] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.Trailer" % ( count ), movie[13] )
            self.WINDOW.setProperty( "AllinOne_MovieRandom.%d.MPAA" % ( count ), movie[15] )
            if count == self.LIMIT:
               break       
                             
    def _setproperties_moviesprogress( self ):
        for count, movie in enumerate( self.moviesprogresslist ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Title" % ( count ), movie[1] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Year" % ( count ), movie[2] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Genre" % ( count ), movie[3][0] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Studio" % ( count ), movie[4][0] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Plot" % ( count ), movie[5] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.PlotOutline" % ( count ), movie[6] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Tagline" % ( count ), movie[7] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.RunningTime" % ( count ), movie[8] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Fanart" % ( count ), movie[9] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Thumb" % ( count ), movie[10] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Path" % ( count ), movie[11] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Rating" % ( count ), movie[12] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.PercentPlayed" % ( count ), movie[13] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.Trailer" % ( count ), movie[14] )
            self.WINDOW.setProperty( "AllinOne_MovieProgress.%d.MPAA" % ( count ), movie[15] )
            if count == self.LIMIT:
               break    
        xbmc.log(msg="terminou filmes em progress")
    def _setproperties_episodesprogress( self ):
        for count, episode in enumerate( self.episodes ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Title" % ( count ), episode[1] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Episode" % ( count ), episode[2] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Season" % ( count ), episode[3] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Plot" % ( count ), episode[4] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.TVShowTitle" % ( count ), episode[5] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Path" % ( count ), episode[6] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Thumb" % ( count ), episode[7] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Fanart" % ( count ), episode[8] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.EpisodeNo" % ( count ), episode[9] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Studio" % ( count ), episode[10][0] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.TvshowThumb" % ( count ), episode[11] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.SeasonThumb" % ( count ), episode[12] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.IsResumable" % ( count ), episode[13] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.Rating" % ( count ), episode[14] )
            self.WINDOW.setProperty( "AllinOne_EpisodeProgress.%d.PercentPlayed" % ( count ), episode[17] )
            if count == self.LIMIT:
               break
            
    def _setproperties_episodesrandom( self ):
        for count, episode in enumerate( self.episodesrandomlist ):
            count += 1
            #[0title, 1showtitle, 2season, 3episode, 4rating, 5plot, 6path, 7thumb, 8fanart, 9episodeno])
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Title" % ( count ), episode[0] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Episode" % ( count ), episode[3] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Season" % ( count ), episode[2] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Plot" % ( count ), episode[5] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.TVShowTitle" % ( count ), episode[1] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Path" % ( count ), episode[6] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Thumb" % ( count ), episode[7] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Fanart" % ( count ), episode[8] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.EpisodeNo" % ( count ), episode[9] )
            #self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Studio" % ( count ), episode[10] )
            #self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.TvshowThumb" % ( count ), episode[11] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.SeasonThumb" % ( count ), episode[10] )
            #self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.IsResumable" % ( count ), episode[13] )
            self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.Rating" % ( count ), episode[4] )
            #self.WINDOW.setProperty( "AllinOne_EpisodeRandom.%d.PercentPlayed" % ( count ), episode[17] )            
            if count == self.LIMIT:
               break
    
    def _setproperties_musicvideosrandom( self ):
        for count, musicvideo in enumerate( self.musicvideosrandomlist ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Title" % ( count ), musicvideo[0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Year" % ( count ), musicvideo[1] )          
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Genre" % ( count ), musicvideo[2][0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Studio" % ( count ), musicvideo[3][0] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Plot" % ( count ), musicvideo[4] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.RunningTime" % ( count ), musicvideo[5] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Fanart" % ( count ), musicvideo[6] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Thumb" % ( count ), musicvideo[7] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.Path" % ( count ), musicvideo[8] )
            self.WINDOW.setProperty( "AllinOne_MusicVideoRandom.%d.PercentPlayed" % ( count ), musicvideo[9] )
            if count == self.LIMIT:
               break              

    def _setproperties_songsrandom( self ):
        for count, songs in enumerate( self.songsrandomlist ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Title" % ( count ), songs[0] )
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Artist" % ( count ), songs[1][0] )  
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Genre" % ( count ), songs[5][0] )
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Year" % ( count ), songs[4] )
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Thumb" % ( count ), songs[3] )
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Fanart" % ( count ), songs[2] )
            self.WINDOW.setProperty( "AllinOne_SongRandom.%d.Path" % ( count ), songs[7] )
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break
            
    def _setproperties_albunsrandom( self ):
        for count, album in enumerate( self.albunsrandom ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Title" % ( count ), album[0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Artist" % ( count ), album[1][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Genre" % ( count ), album[5][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Year" % ( count ), album[4] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Thumb" % ( count ), album[3] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Fanart" % ( count ), album[2] )
            self.WINDOW.setProperty( "AllinOne_AlbumRandom.%d.Path" % ( count ), album[6] )
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break       

    def _setproperties_albumprogress( self ):
        for count, album in enumerate( self.albums ):
            count += 1
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Title" % ( count ), album[0] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Artist" % ( count ), album[1][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Genre" % ( count ), album[2][0] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Year" % ( count ), album[3] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Album_Label" % ( count ), album[4] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Album_Description" % ( count ), album[5] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Rating" % ( count ), album[6] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Thumb" % ( count ), album[7] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Fanart" % ( count ), album[8] )
            self.WINDOW.setProperty( "AllinOne_AlbumProgress.%d.Path" % ( count ), album[9] )
            if count == int(self.LIMIT):
                # stop here if our list contains more items
                break 
            
    def _clearproperties_moviesrandom( self ):
        for count in range (self.LIMIT):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MovieRandom.%d.Title" % ( count ) )
            
    def _clearproperties_moviesprogress( self ):
        for count in range (self.LIMIT):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MovieProgress.%d.Title" % ( count ) )

    def _clearproperties_episodesprogress( self ):
        for count in range( (self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_EpisodeProgress.%d.Title" % ( count ) )
            
    def _clearproperties_episodesrandom( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_EpisodeRandom.%d.Title" % ( count ) )
    
    def _clearproperties_musicvideosrandom( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MusicVideoRandom.%d.Title" % ( count ) )
            
    def _clearproperties_musicvideosrecents( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_MusicVideoRecents.%d.Title" % ( count ) )
            
    def _clearproperties_albunsrandom( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_AlbumRandom.%d.Title" % ( count ) )
            
    def _clearproperties_songsrandom( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_SongRandom.%d.Title" % ( count ) )                
            
    def _clearproperties_albumprogress( self ):
        for count in range((self.LIMIT) ):
            count += 1
            self.WINDOW.clearProperty( "AllinOne_AlbumProgress.%d.Title" % ( count ) )                                                
            
    def _update( self, type, item, ended ):
      if self.MOVIES == 'true':
        if type == 'movie':
            xbmc.log(msg="iniciou o uptdate de filmes")
            found = False
            # Delete movie progress from lists
            for count, movie in enumerate( self.moviesprogresslist ):
                if movie[11] == item[11]:
                    item[9] = movie[9]
                    item[10] = movie[10]
                    item[14] = movie[14]
                    item[15] = movie[15]
                    del self.moviesprogresslist[count]
                    found = True
                    break
            # If movie has a resume point, add it at the beginning
            if not ended:
                if found:
                    self.moviesprogresslist.insert( 0, item )
                else:
                    for newprogress in self.movies:
                        if newprogress[10] == item[11]:
                            item[9] = newprogress[8]
                            item[10] = newprogress[9]
                            item[14] = newprogress[14]
                            item[15] = newprogress[16]
                            self.moviesprogresslist.insert( 0, item )
                            break
# movies [0title, 1year, 2genre, 3studio, 4plot, 5plotoutline, 6tagline, 7runtime, 8fanart, 9thumbnail, 10path, 11rating, 12lastplayed, 13percentplayed, 14trailer, 15resumeposition
# item[0"", 1title, 2year, 3genre, 4studio, 5plot, 6plotoutline, 7tagline, 8runtime, 9"", 10"", 11path, 12rating, 13"", 14""]
# progress[0lastplayed, 1title, 2year, 3genre, 4studio, 5plot, 6plotoutline, 7tagline, 8runtime, 9fanart, 10thumbnail, 11path, 12rating, 13percentplayed, 14trailer])

            self._clearproperties_moviesprogress()
            self._setproperties_moviesprogress()
        elif type == 'episode':
          if self.EPISODES == 'true':
            # Only update if it was a new, unwatched episode
            if item[15] == 0:
                for tvshow in self.tvshows:
                    xbmc.log(msg="passou na condicional 441")
                    # If tv show names match, set missing values
                    if tvshow[3] == item[5]:
                        # se a serie ja se encontra na lista tvshow
                        fanart = tvshow[4]
                        item[8] = fanart
                        item[10] = tvshow[2]
                        item[11] = tvshow[1]
                        tvshowid = tvshow[0]
                        item[16] = tvshowid
                        if self.EPISODEBARHIDE == 'true':
                           item[17] = '0'
                        # Delete episode from watch list episodes
                        new = True
                        xbmc.log(msg="passou na condicional 451")
                        for count, episode in enumerate( self.episodes ):
                            # Se a serie ja se encontra na lista episodes
                            if episode[5] == item[5]:
                                # record our seasonthumb here since we need it later on
                                seasonthumb = episode[12]
                                item[12] = seasonthumb
                                item[7] = episode[7]
                                for epthumb in tvshow[5]:
                                    seasonnumber = "%.2d" % float(epthumb['season'])
                                    episodenumber = "%.2d" % float(epthumb['episode'])
                                    if episodenumber == item[2] and seasonnumber == item[3]:
                                        item[7] = self._fetch_episodethumb(tvshowid, seasonnumber, episodenumber)
                                xbmc.log(msg="passou na condicional 464")
                                del self.episodes[count]
                                new = False
                                break
                        # If the show is marked as watched, check for a new episode to add
                        # else add the episode at the beginning of the list
                        if ended:
                            xbmc.log(msg="passou na condicional 472")
                            update = False
                            insert = False
                            for ep in tvshow[5]:
                                xbmc.log(msg="passou na condicional 475")
                                seasonnumber = "%.2d" % float(ep['season'])
                                episodenumber = "%.2d" % float(ep['episode'])
                                if ( episodenumber != item[2] or seasonnumber != item[3] ) and ep['playcount'] == 0:
                                    if seasonnumber != item[3]:
                                        # our new episode is from the next season, so fetch seasonthumb
                                        seasonthumb = self._fetch_seasonthumb(tvshowid, seasonnumber)
                                    xbmc.log(msg="passou na condicional 482")
                                    percentplayed = '0'
                                    if self.EPISODEBARHIDE == 'false':
                                       percentplayed = self._fetch_episodepercent(tvshowid, seasonnumber, episodenumber)                                    
                                    thumbnail = self._fetch_episodethumb(tvshowid, seasonnumber, episodenumber)
                                    self.episodes.insert( 0, [ep['lastplayed'], ep['title'], episodenumber, seasonnumber, ep['plot'], ep['showtitle'], ep['file'], thumbnail, fanart, "s%se%s" % ( seasonnumber,  episodenumber, ), tvshow[2], tvshow[1], seasonthumb, "True", str(round(float(ep['rating']),1)), ep['playcount'],tvshowid, percentplayed] )
                                    insert = True
                                    if update:
                                        xbmc.log(msg="passou na condicional 472")
                                        break
                                elif episodenumber == item[2] and seasonnumber == item[3]:
                                    xbmc.log(msg="passou na condicional 492")
                                    ep['playcount'] = 1
                                    update = True
                                    if insert:
                                        break
                        else:
                            # If the episode wasn't in the watch list before, set season and episode thumb
                            if new:
                                xbmc.log(msg="passou na condicional 494")
                                for ep in tvshow[5]:
                                    seasonnumber = "%.2d" % float(ep['season'])
                                    episodenumber = "%.2d" % float(ep['episode'])
                                    if episodenumber == item[2] and seasonnumber == item[3]:
                                        item[7] = self._fetch_episodethumb(tvshowid, seasonnumber, episodenumber)
                                        item[12] = self._fetch_seasonthumb(tvshowid, seasonnumber)
                                        #item[17] = self._fetch_episodepercent(tvshowid, seasonnumber, episodenumber)
                                        break
                            self.episodes.insert( 0, item )
                        break
                self._clearproperties_episodesprogress()
                xbmc.log(msg="limpou os dados no update")
                self._setproperties_episodesprogress()
                xbmc.log(msg="setou os dados no update")
        elif type == 'album':
            xbmc.sleep(1000)
            self._fetch_songs()
            self._fetch_albums()
            self._clearproperties_albumprogress()
            self._setproperties_albumprogress()                    
            
class MyPlayer(xbmc.Player):
    def __init__( self, *args, **kwargs ):
        xbmc.Player.__init__( self )
        self.action = kwargs[ "action" ]
        self.movies = kwargs[ "movies" ]
        self.episodes = kwargs[ "episodes" ]
        self.albums = kwargs[ "albums" ]
        self.substrings = [ '-trailer', 'http://' ]
        self.timer = ""
        self.initValues()
           
    def onPlayBackStarted( self ):
        # Set values based on the file content
        if ( self.isPlayingAudio() ):
            self.setValues( 'album' )   
        else:
            # Stop timer thread on start
            self.stopTimer()
            # Update if an item was played (player is playing a playlist)
            if len(self.item) > 0:
                if self.type == 'movie' and self.movies:
                    self.action( 'movie', self.item, ( self.time < 3*60 or self.totalTime * 0.9 <= self.time ) )
                if self.type == 'episode' and self.episodes:
                    self.action( 'episode', self.item, ( self.totalTime * 0.9 <= self.time ) )
                self.initValues()  
            # Start timer thread
            self.timer = Thread(target=self.startTimer)
            self.timer.start()
            if xbmc.getCondVisibility( 'VideoPlayer.Content(movies)' ):
                filename = ''
                isMovie = True
                try:
                    filename = self.getPlayingFile()
                except:
                    pass
                if filename != '':
                    for string in self.substrings:
                        if string in filename:
                            isMovie = False
                            break
                if isMovie:
                    self.setValues( 'movie' )
            elif xbmc.getCondVisibility( 'VideoPlayer.Content(episodes)' ):
                # Check for tv show title and season to make sure it's really an episode
                if xbmc.getInfoLabel('VideoPlayer.Season') != "" and xbmc.getInfoLabel('VideoPlayer.TVShowTitle') != "":
                    self.setValues( 'episode' )

    def onPlayBackEnded( self ):
        self.stopTimer()
        if self.type == 'album' and self.albums:
            self.action( 'album', self.item, True )
        if self.type == 'movie' and self.movies:
            self.action( 'movie', self.item, True )
        if self.type == 'episode' and self.episodes:
            self.action( 'episode', self.item, True )
        self.initValues()

    def onPlayBackStopped( self ):
        self.stopTimer()
        if self.type == 'album' and self.albums:
            self.action( 'album', self.item, True )
        if self.type == 'movie' and self.movies:
            percentmovie = (int(self.time) * 100) / int(self.totalTime)
            percentmovie = str(percentmovie)
            
            self.item[13] = percentmovie
            xbmc.log(msg="tempo supostamente total filmes " + percentmovie)
            self.action( 'movie', self.item, ( self.time < 3*60 or self.totalTime * 0.90 <= self.time ) )
        if self.type == 'episode' and self.episodes:
            percstopepisode = (int(self.time) * 100) / int(self.totalTime)
            percstopepisode = str(percstopepisode)
            self.item[17] = percstopepisode
            xbmc.log(msg="tempo supostamente total episodes" + percstopepisode)
            self.action( 'episode', self.item, ( self.totalTime * 0.90 <= self.time ) )
        self.initValues()

    def setValues( self, type ):
        self.type = type
        self.totalTime = 0
        try:
            self.totalTime = self.getTotalTime()
        except:
            pass
        if type == 'movie':
            title = xbmc.getInfoLabel('VideoPlayer.Title')
            year = xbmc.getInfoLabel('VideoPlayer.Year')
            genre = xbmc.getInfoLabel('VideoPlayer.Genre')
            studio = xbmc.getInfoLabel('VideoPlayer.Studio')
            plot = xbmc.getInfoLabel('VideoPlayer.Plot')
            plotoutline = xbmc.getInfoLabel('VideoPlayer.PlotOutline')
            tagline = xbmc.getInfoLabel('VideoPlayer.TagLine')
            runtime = xbmc.getInfoLabel('VideoPlayer.Duration')
            path = xbmc.getInfoLabel('Player.Filenameandpath')
            rating = str(xbmc.getInfoLabel('VideoPlayer.Rating'))
            self.item = ["", title, year, genre, studio, plot, plotoutline, tagline, runtime, "", "", path, rating, "", "", ""]
        elif type == 'episode':
            title = xbmc.getInfoLabel('VideoPlayer.Title')
            episode = "%.2d" % float(xbmc.getInfoLabel('VideoPlayer.Episode'))
            path = xbmc.getInfoLabel('Player.Filenameandpath')
            plot = xbmc.getInfoLabel('VideoPlayer.Plot')
            season = "%.2d" % float(xbmc.getInfoLabel('VideoPlayer.Season'))
            showtitle = xbmc.getInfoLabel('VideoPlayer.TVShowTitle')
            rating = str(xbmc.getInfoLabel('VideoPlayer.Rating'))
            episodeno = "s%se%s" % ( season,  episode, )
            studio = xbmc.getInfoLabel('VideoPlayer.Studio')
            playcount = xbmc.getInfoLabel('VideoPlayer.PlayCount')
            if playcount != "":
                playcount = int(playcount)
            else:
                playcount = 0
            self.item = ["", title, episode, season, plot, showtitle, path, "", "", episodeno, "", "", "", "True", rating, playcount, "", ""]
                
        elif type == 'album':
            pass

    def initValues( self ):
        self.item = []
        self.type = ""
        self.time = 0
        self.totaltime = 0

    def startTimer( self ):
        runtime = 0
        self.shutdown = False
        setTime = False
        while( self.isPlaying() and self.shutdown == False ):
            try:
                runtime = self.getTime()
                setTime = True
            except:
                setTime = False
            if (runtime <= 2):
                xbmc.sleep(5000)
            else:
                xbmc.sleep(1000)
            if setTime:
                self.time = runtime

    def stopTimer( self ):
        if self.timer != "":
            self.shutdown = True
            xbmc.sleep(100)
            if self.timer.isAlive():
                self.timer.join()
                
          
class UpdateRandom(aioupdate.Uprandom):
      def __init__( self, *args, **kwargs ):
          aioupdate.Uprandom.__init__( self )
          self.WINDOW = xbmcgui.Window( 10000 )
          self.upaction = kwargs["upaction"]
          self.strupaction = str(self.upaction)
      def _upmovierandom(self):
          self.upaction()

class callfetchrecents(Thread):
    def __init__ (self):
        Thread.__init__(self)
    def run(self):
        aiorecents.Main()
                                              
if ( __name__ == "__main__" ):
    log('script version %s started' % __addonversion__)
    Main()      