import re
import requests
from ..scraper import Scraper
import xbmc
from BeautifulSoup import BeautifulSoup
from ..common import clean_title, replaceHTMLCodes
import urlparse
User_Agent = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36'

class Animetoon(Scraper):
    name = "Animetoon"
    domains = ['animetoon.org']
    sources = []

    def __init__(self):
        self.base_link = 'http://www.animetoon.org/'
        self.search_link = "/toon/search?key=%s"

    def scrape_episode(self, title, show_year, year, season, episode, imdb, tvdb, debrid = False):
        if season == "19":
            season = "1"
        try:
            url = 'http://www.animetoon.org/toon/search?key='+title.replace(' ','+')
            headers={'User-Agent':User_Agent}
            html = requests.get(url,headers=headers,timeout=5).content
            match = re.compile('<div class="right_col">.+?href="(.+?)".*?>(.+?)</a>.*?<span class="small">Released:.*?<span class="bold">(.+?)</span>',re.DOTALL).findall(html)
            for url2, link_title, link_year in match:
                if not link_title.lower().startswith(title.lower()):
                    continue
                if not title.lower() == link_title.lower() and not title.lower() + " season" in link_title.lower():
                    continue
                headers={'User-Agent':User_Agent}
                html2 = requests.get(url2,headers=headers,timeout=5).content
                self.process_episode_page(html2, season, episode)
                page_match = re.compile('<ul class="pagination">.+?href="(.+?)"', re.DOTALL).findall(html2)
                for page_url in page_match:
                    headers={'User-Agent':User_Agent}
                    html2 = requests.get(page_url,headers=headers,timeout=5).content
                    self.process_episode_page(html2, season, episode)
            return self.sources
        except Exception as e:
            return []

    def process_episode_page(self, html2, season, episode):
        block = re.compile('<div id="videos">(.+?)</div>',re.DOTALL).findall(html2)
        for item in block:
            single = re.compile('<a href="(.+?)"').findall(str(block))
            for thing in single:
                if not int(season) == 1 and not "season-" + season in thing:
                    continue
                if thing.endswith("episode-" + episode):
                    headers={'User-Agent':User_Agent}
                    html3 = requests.get(thing,headers=headers,timeout=5).content
                    match2 = re.compile('<div class="vmargin">.+?src="(.+?)"').findall(html3)
                    for playlink in match2:
                        if 'zoo' in playlink:
                            playname = 'Videozoo'
                        elif 'bb' in playlink:
                            playname = 'Playbb'
                        elif 'easy' in playlink:
                            playname = 'Easyvideo'
                        elif 'panda' in playlink:
                            playname = 'Playpanda'
                        else:
                            playname = "unknown"
                        headers={'User-Agent':User_Agent}
                        html4 = requests.get(playlink,headers=headers,timeout=5).content
                        play = re.compile('"link":"(.+?)"').findall(html4)
                        for link in play:
                            playlink = link.replace('\\', '')
                            self.sources.append(
                                {'source': playname, 'quality': 'SD',
                                 'scraper': self.name, 'url': playlink,
                                 'direct': True})
                            _url = re.compile('_url = "(.+?)"').findall(html4)
                            for i in _url:
                                playlink = link.replace('\\', '')
                                self.sources.append(
                                    {'source': playname, 'quality': 'SD',
                                     'scraper': self.name, 'url': playlink,
                                     'direct': True})
