import re
import xbmc
from ..scraper import Scraper
from ..common import clean_search,random_agent,non_func_hosts
from md_request import open_url
import urlresolver
#User_Agent = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36'
                                           
class vodlockerapi(Scraper):
    domains = ['http://vodlocker.to']
    name = "Vodlocker"
    sources = []

    def __init__(self):
        self.base_link = 'http://vodlocker.to'
                       

    def scrape_movie(self, title, year, imdb, debrid = False):
        try:
            search_id = clean_search(title.lower())
            start_url = '%s/embed?t=%s&y=%s' %(self.base_link,search_id.replace(' ','%20'),year)
            #print 'START url '+start_url
            headers={'User-Agent': random_agent()}
            html = open_url(start_url,headers=headers,redirects=True,timeout=5).content
            movID =  re.compile('var id = "(.+?)"',re.DOTALL).findall(html)[0]
            url = '%s/embed/movieStreams/?id=%s' %(self.base_link,movID)
            #print 'VODurl= '+url
            self.get_source(url)
            return self.sources
        except:
            pass
            return[]
         
    def scrape_episode(self,title, show_year, year, season, episode, imdb, tvdb, debrid = False):
        try:
            search_id = clean_search(title.lower())
            start_url = '%s/embed?t=%s&season=%s&episode=%s' %(self.base_link,search_id.replace(' ','%20'),season,episode)
            headers={'User-Agent': random_agent()}
            html = open_url(start_url,headers=headers,redirects=True,timeout=5).content
            movID =  re.compile('var id = "(.+?)"',re.DOTALL).findall(html)[0]
            url = '%s/embed/movieStreams/?id=%s&e=%s&cat=episode' %(self.base_link,movID,episode)
            self.get_source(url)
            return self.sources
        except:
            pass
            return[]

    def get_source(self,url):
        try:
            #print 'get_sources> ' + url
            headers={'User-Agent': random_agent()}
            OPEN = open_url(url,headers=headers,timeout=5).content
            Regex = re.compile('onclick=\'show_player\(".+?", "(.+?)"',re.DOTALL).findall(OPEN)
            for link in Regex:
                if 'docs.google' in link:
                    host = 'Docs.Google'
                    res = 'HD'
                    self.sources.append({'source': host, 'quality': res, 'scraper': self.name, 'url': link,'direct': False})
                else:
                    if urlresolver.HostedMediaFile(link).valid_url():
                        host = link.split('//')[1].replace('www.','')
                        host = host.split('/')[0].split('.')[0].title()
                        res = 'DVD'
                        if not non_func_hosts(host.lower()):
                            continue
                        self.sources.append({'source': host, 'quality': res, 'scraper': self.name, 'url': link,'direct': False})
                   
        except:
            pass

