/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986

   Description:

   Implements the InitVIS550()procedure that initializes the generic VDU
   routines and parameters used in DVItoVDU.  The VIS550 VDU has an
   Alphanumeric mode in which it behaves like a VT100, but it can also
   emulate a Tektronix 4010 terminal in which the screen is 1024 pixels
   wide by 780 pixels high.  The VIS550 is, therefore, almost exactly
   the same as the VT640 VDU, but can do rectangular draw and fill like
   the VIS500, and terse mode characters need to be dragged down.

   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.

   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/

#include "def.h"
#include "dvitovdu.h"

static char *sccsid[] = "@(#)vis550vdu.c	1.1";

extern Void TEK4010LoadFont(),
            TEK4010StartGraphics(),
            TEK4010StartText(),
            VIS500ResetVDU(),
            VIS500ShowRectangle(),
            VIS500ShowChar(),
            VT640ClearScreen(),
            VT640ClearTextLine(),
            VT640MoveToTextLine();

/******************************************************************************/

void InitVIS550 ()
{

/* The dialog region will be the top 4 text lines in VT100 mode:
      Line 1 = DVI status line,
      Line 2 = window status line,
      Line 3 = message line,
      Line 4 = command line.
   The window region will be text lines 5 to 33 in VT100 mode.
*/

  DVIstatusl = 1;		/* DVItoVDU assumes top text line = 1 */
  windowstatusl = 2;
  messagel = 3;
  commandl = 4;
  bottoml = 33;			/* also number of text lines on screen */
/* The above values assume the VIS550 is in VT100 mode;
   the following values assume it is emulating a Tektronix 4010.
   Note that windowv must be given a value using DVItoVDU's coordinate scheme
   where top left pixel is (0,0).
*/
  windowv = 92;			/* approx. height in TEK4010 pixels of 4 text lines
				   i.e. ~ 4 * 780/34 */
  windowh = 0;
  windowht = 780 - windowv;
  windowwd = 1024;

  MoveToTextLine = VT640MoveToTextLine;
  ClearTextLine = VT640ClearTextLine;
  ClearScreen = VT640ClearScreen;
  StartText = TEK4010StartText;
  StartGraphics = TEK4010StartGraphics;
  LoadFont = TEK4010LoadFont;
  ShowChar = VIS500ShowChar;
  ShowRectangle = VIS500ShowRectangle;
  ResetVDU = VIS500ResetVDU;

  Write (GS);
  Write (ESC);
  Write ('@');			/* solid fill for rectangular draw and fill */
  Write (CAN);
}

/******************************************************************************/
