DVItoVDU is an interactive TeX page previewer.  The program allows you to
look at TeX-generated DVI files on a variety of commonly available VDUs.

USAGE:  dv  filename[.dvi]
            [-v vdu]  [-m magnification]  [-r resolution]
            [-x paper_width]  [-y paper_height]  [-l]
            [-f pk_font_directory]  [-d dummy_font]  [-h help_file]
            [-t tfm_directory]  [-p postscript_tfm_prefix]
            [-ho horizontal_offset]  [-vo vertical_offset]

COMMAND OPTIONS:

-v string   (default=value of TERM)

This option is used to tell DVItoVDU what type of VDU you are using.
If TERM does not describe your VDU, you need to override the default value.
Typing `dv -v vis603 foo' will tell DVItoVDU you're using a VISUAL 603.
The current version will accept the following strings:

aed512    (AED 512 with 512 by 512 screen)
regis     (any ReGIS compatible VDU; synonyms = gigi, vk100, vt125, vt240)
vis240    (VISUAL 240)
vis500    (VISUAL 500)
vis550    (VISUAL 550)
vis603    (VISUAL 603)
vis630    (VISUAL 630)
vt100     (any VT100 compatible VDU)
vt100132  (any VT100 compatible VDU in 132 column mode)
vt220     (VT220 using down-loaded chunky graphics)
vt640     (VT100 with Retro-Graphics)

-m integer   (default=DVI magnification)

This option allows you to replace the magnification used in the
DVI file with some other value; ie. a positive integer 1000 times
the desired magnification.  The given value should be chosen carefully
so that the new font sizes still correspond to existing PK files.
Unless you know exactly what you are doing you should avoid using -m,
especially if your TeX source file uses \magnification AND true dimensions.

-r integer   (default=300)

DVItoVDU treats the imaginary sheet of paper on which a DVI page will
appear as a two dimensional array of tiny dots known as paper pixels.
The specified integer defines the number of pixels per inch,
horizontally and vertically.  Its value should match the resolution
of the device that will be used to print your document.
For example, the Apple LaserWriter has a resolution of 300 dots/inch.

-x dimension   (default=8.3in)
-y dimension   (default=11.7in)

These two options define the width and height of the paper upon which your
document will be printed.  Both values are specified as dimensions like
those used in TeX, but the units are restricted to IN, CM, MM, PC, PT or PX.
The default values specify A4 paper.
Every time you select a page, DVItoVDU will use these paper dimensions
to check that all printed material falls within the paper edges.

-l

Swaps the paper width and height values for previewing landscaped output.

-f directory   (default=/usr/local/bin/dvitovdu/pk/)

DVItoVDU gets all its bit-mapped font information from PK files.
These files are kept within the directory specified by this option.

-d file   (default=cmr10.300pk)

DVItoVDU will warn you if your document uses a font at a non-existent size.
Rather than abort, it will load the PK file specified after -d and
continue so you can look for more errors.  Paragraphs using this dummy
information are likely to have ragged right margins.

-h file   (default=/usr/local/bin/dv/help)

The ? command reads the text file specified by this option.
The default help file contains a brief summary of all the commands.

-t directory   (default=/usr/local/lib/tex/fonts/)

Specifies the location of TFM files for printer-resident PostScript fonts.
DVItoVDU needs to read TFM files if your document uses such fonts
since bit-mapped information does not exist.

-p string   (default=ps-)

DVItoVDU recognizes a PostScript font by checking the font name for a
unique prefix.

-ho dimension   (default=0in)
-vo dimension   (default=0in)

These options can be used to shift the location of each page within
the paper.  You should only need to use them if you plan to print the
document with similar offsets.  Negative dimensions are allowed;
for example, "-ho -.5in" shifts each page half an inch to the left.
