CFLAGS =
CXXFLAGS =
SHELL = /bin/sh
CFILES = buffer.c button.c debug.c default.c edit.c events.c find.c \
           getstring.c intstack.c keymap.c menu.c message.c notadef.c \
           notation.c notatype.c output.c remark.c scrollbar.c sources.c \
           symbol.c system.c flex.c fileread.c fstate.c fileselc.c popup.c \
           funcs.c helpfile.c checkbox.c match.c leaftree.c
CXXFILES = editor.cc editwindow.cc mark.cc marker.cc mathpad.cc node.cc \
           select.cc
OBJECTS  = $(CFILES:.c=.o) $(CXXFILES:.cc=.o)

all: mathpad mathpad.1 xpipein xpipeout ispellfilter pktobdf

mathpad:  $(OBJECTS)
	@echo $(CXX) $(CXXFLAGS) -o mathpad $(OBJECTS) $(LDLIBS) >> makeld.log
	($(CXX) $(CXXFLAGS) -o mathpad $(OBJECTS) $(LDLIBS) 2>&1) >> makeld.log

mathpad.1:
	@cat mathpad.man | sed -e 's#MATHPADLIBDIRECTORY#'$(MATHPADHOME)'#g' > mathpad.1

xpipein:  xpipein.o
	@echo $(CC) $(CFLAGS) -o xpipein xpipein.o $(LDLIBS) >> makeld.log
	($(CC) $(CFLAGS) -o xpipein xpipein.o $(LDLIBS) 2>&1) >> makeld.log

xpipeout:  xpipeout.o
	@echo $(CC) $(CFLAGS) -o xpipeout xpipeout.o $(LDLIBS) >> makeld.log
	($(CC) $(CFLAGS) -o xpipeout xpipeout.o $(LDLIBS) 2>&1) >> makeld.log

pktobdf:  pktobdf.o
	@echo $(CC) $(CFLAGS) -o pktobdf pktobdf.o  >> makeld.log
	($(CC) $(CFLAGS) -o pktobdf pktobdf.o 2>&1) >> makeld.log

ispellfilter: ispellfilter.o
	@echo $(CC) $(CFLAGS) -o ispellfilter ispellfilter.o >> makeld.log
	($(CC) $(CFLAGS) -o ispellfilter ispellfilter.o 2>&1) >> makeld.log

depend:
	makedepend $(EXTRA_DEFINES) $(CFILES) $(CXXFILES) xpipein.c xpipeout.c ispellfilter.c pktobdf.c

check:
	@./checkerrors
	@rm -f config.h

config: config.h

config.h: Makefile
	@rm -f config.h
	@echo '#define MATHPADHOME "'$(MATHPADHOME)'"' > config.h
	@echo '#define DEL_BACK_SWITCH '$(DEL_BACK_SWITCH) >> config.h

clean:
	@rm -f config.h *.o *.log mathpad core Makefile *.bak unproto

.SUFFIXES: .cc .c

.cc.o:
	@echo $(CXX) $(INCLUDE) $(DEFINES) $(CXXFLAGS) -c $< >> makeC++.log
	($(CXX) $(INCLUDE) $(DEFINES) $(CXXFLAGS) -c $< 2>&1) >> makeC++.log

.c.o:
	@echo $(CC) $(INCLUDE) $(DEFINES) $(CFLAGS) -c $< >> makeC.log
	($(CC) $(INCLUDE) $(DEFINES) $(CFLAGS) -c $< 2>&1) >> makeC.log

# DO NOT DELETE THIS LINE -- make depend depends on it.

buffer.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
buffer.o: button.h keymap.h message.h scrollbar.h output.h buffer.h editor.h
buffer.o: helpfile.h
button.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
button.o: button.h message.h helpfile.h
default.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
default.o: button.h keymap.h getstring.h message.h default.h popup.h
default.o: helpfile.h checkbox.h
edit.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
edit.o: keymap.h message.h button.h scrollbar.h remark.h output.h fileread.h
edit.o: notatype.h flex.h edit.h editor.h menu.h fileselc.h helpfile.h
edit.o: popup.h
events.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
events.o: keymap.h button.h message.h scrollbar.h getstring.h remark.h
events.o: symbol.h edit.h buffer.h default.h notatype.h flex.h notadef.h
events.o: notation.h output.h find.h menu.h events.h fileselc.h popup.h
events.o: checkbox.h
find.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
find.o: button.h message.h output.h scrollbar.h keymap.h find.h fileread.h
find.o: fileselc.h notatype.h flex.h editor.h popup.h helpfile.h
getstring.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
getstring.o: keymap.h output.h message.h getstring.h helpfile.h
intstack.o:   intstack.h
keymap.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
keymap.o: message.h output.h keymap.h  ownkeys.h config.h
menu.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
menu.o: keymap.h message.h button.h symbol.h edit.h buffer.h default.h
menu.o: notatype.h flex.h notation.h output.h find.h editor.h menu.h popup.h
menu.o: fileselc.h helpfile.h
message.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
message.o: output.h remark.h message.h
notadef.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
notadef.o: keymap.h button.h symbol.h output.h scrollbar.h message.h
notadef.o: notatype.h flex.h notadef.h notation.h popup.h helpfile.h
notation.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
notation.o: button.h scrollbar.h remark.h message.h output.h keymap.h
notation.o: notatype.h flex.h notadef.h notation.h fileselc.h menu.h popup.h
notation.o: helpfile.h 
notatype.o: mathpad.h system.h funcs.h sun_kludge.h debug.h
notatype.o: intstack.h notatype.h flex.h message.h fileread.h output.h
output.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
output.o: message.h output.h buffer.h edit.h intstack.h
remark.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
remark.o: button.h keymap.h getstring.h scrollbar.h output.h remark.h
remark.o: intstack.h helpfile.h
scrollbar.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
scrollbar.o: message.h scrollbar.h helpfile.h
sources.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
sources.o: message.h notatype.h flex.h output.h remark.h intstack.h
sources.o:  config.h progicon
symbol.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
symbol.o: button.h message.h symbol.h keymap.h helpfile.h
system.o:  mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
system.o: config.h
flex.o:  flex.h
fileread.o:  mathpad.h fileread.h debug.h sun_kludge.h
fstate.o:  debug.h fstate.h
fileselc.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
fileselc.o: button.h getstring.h scrollbar.h keymap.h message.h output.h
fileselc.o: fstate.h fileselc.h helpfile.h
popup.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
popup.o: output.h popup.h helpfile.h
funcs.o: mathpad.h system.h funcs.h  sun_kludge.h debug.h
helpfile.o: helpfile.h
checkbox.o: mathpad.h system.h funcs.h sun_kludge.h debug.h
checkbox.o: sources.h checkbox.h message.h
leaftree.o:   leaftree.h
match.o: mathpad.h match.h leaftree.h intstack.h debug.h
editor.o:  mathpad.h output.h keymap.h editor.h
editor.o: fileread.h mathpad.hh mark.hh marker.hh node.hh notatype.h flex.h
editor.o: select.hh editwindow.hh mathpad.icc mark.icc marker.icc select.icc
editor.o: editwindow.icc
editwindow.o:  mathpad.h output.h message.h mathpad.hh
editwindow.o: mark.hh marker.hh node.hh notatype.h flex.h select.hh
editwindow.o: editwindow.hh mathpad.icc mark.icc marker.icc select.icc
editwindow.o: editwindow.icc
mark.o:  mathpad.h mathpad.hh mark.hh marker.hh
mark.o: node.hh notatype.h flex.h mathpad.icc mark.icc marker.icc select.icc
mark.o: editwindow.icc
marker.o:  mathpad.h mathpad.hh mark.hh marker.hh node.hh
marker.o: notatype.h flex.h mathpad.icc mark.icc marker.icc select.icc
marker.o: editwindow.icc
mathpad.o: events.h
node.o:   debug.h mathpad.h flex.h notatype.h output.h message.h fileread.h 
node.o: mathpad.hh mark.hh marker.hh node.hh mathpad.icc mark.icc marker.icc
node.o: select.icc editwindow.icc
select.o:  message.h mathpad.h debug.h mathpad.hh mark.hh
select.o: marker.hh node.hh notatype.h flex.h select.hh editwindow.hh
select.o: mathpad.icc mark.icc marker.icc select.icc editwindow.icc
xpipein.o: xpipein.c
xpipeout.o: xpipeout.c
ispellfilter.o: ispellfilter.c
pktobdf.o: pktobdf.c
buffer.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
buffer.o: keymap.h message.h scrollbar.h output.h buffer.h editor.h
button.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
button.o: message.h
default.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
default.o: keymap.h getstring.h message.h default.h popup.h
edit.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h keymap.h
edit.o: message.h button.h scrollbar.h remark.h output.h fileread.h notatype.h
edit.o: edit.h editor.h menu.h fileselc.h
events.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h keymap.h
events.o: button.h message.h scrollbar.h getstring.h remark.h symbol.h edit.h
events.o: buffer.h default.h notatype.h notadef.h notation.h output.h find.h
events.o: menu.h events.h fileselc.h popup.h
find.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
find.o: message.h output.h scrollbar.h keymap.h find.h fileread.h fileselc.h
find.o: notatype.h editor.h popup.h
getstring.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h
getstring.o: keymap.h output.h message.h getstring.h
intstack.o: intstack.h
keymap.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h message.h
keymap.o: output.h keymap.h  ownkeys.h config.h
menu.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h keymap.h
menu.o: message.h button.h symbol.h edit.h buffer.h default.h notatype.h
menu.o: notation.h output.h find.h editor.h menu.h popup.h fileselc.h
message.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h output.h
message.o: remark.h message.h
notadef.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h keymap.h
notadef.o: button.h symbol.h output.h scrollbar.h message.h notatype.h
notadef.o: notadef.h notation.h popup.h
notation.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
notation.o: scrollbar.h remark.h message.h output.h keymap.h notatype.h
notation.o: notadef.h notation.h fileselc.h popup.h
notatype.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h flex.h
notatype.o: intstack.h notatype.h notation.h message.h menu.h remark.h output.h
notatype.o: keymap.h editor.h fileread.h
output.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h message.h
output.o: output.h buffer.h edit.h intstack.h
remark.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
remark.o: keymap.h getstring.h scrollbar.h output.h remark.h intstack.h
scrollbar.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h
scrollbar.o: message.h scrollbar.h
sources.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h message.h
sources.o: notatype.h output.h remark.h intstack.h config.h progicon
symbol.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
symbol.o: message.h symbol.h keymap.h
system.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h config.h
flex.o: flex.h
fileread.o: mathpad.h fileread.h debug.h sun_kludge.h
fstate.o: fstate.h
fileselc.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h button.h
fileselc.o: getstring.h scrollbar.h keymap.h message.h output.h fstate.h
fileselc.o: fileselc.h
popup.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h output.h
popup.o: popup.h
funcs.o: mathpad.h system.h funcs.h  sun_kludge.h debug.h
editor.o: mathpad.h output.h keymap.h editor.h fileread.h mathpad.hh mark.hh
editor.o: marker.hh node.hh select.hh editwindow.hh mathpad.icc mark.icc
editor.o: marker.icc select.icc editwindow.icc
editwindow.o: mathpad.h output.h message.h mathpad.hh mark.hh marker.hh
editwindow.o: node.hh select.hh editwindow.hh mathpad.icc mark.icc marker.icc
editwindow.o: select.icc editwindow.icc
mark.o: mathpad.h mathpad.hh mark.hh marker.hh node.hh mathpad.icc mark.icc
mark.o: marker.icc select.icc editwindow.icc
marker.o:  mathpad.h mathpad.hh mark.hh marker.hh node.hh mathpad.icc mark.icc
marker.o: marker.icc select.icc editwindow.icc
mathpad.o: events.h
node.o: debug.h mathpad.h flex.h notatype.h output.h message.h fileread.h
node.o: mathpad.hh mark.hh marker.hh node.hh mathpad.icc mark.icc marker.icc
node.o: select.icc editwindow.icc
select.o: message.h mathpad.h debug.h mathpad.hh mark.hh marker.hh node.hh
select.o: select.hh editwindow.hh mathpad.icc mark.icc marker.icc select.icc
select.o: editwindow.icc
buffer.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
buffer.o: button.h keymap.h message.h scrollbar.h output.h buffer.h editor.h
buffer.o: helpfile.h
button.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
button.o: button.h message.h helpfile.h
default.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
default.o: button.h keymap.h getstring.h message.h default.h popup.h
default.o: helpfile.h checkbox.h
edit.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
edit.o: keymap.h message.h button.h scrollbar.h remark.h output.h fileread.h
edit.o: notatype.h flex.h edit.h editor.h menu.h fileselc.h helpfile.h
edit.o: popup.h
events.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
events.o: keymap.h button.h message.h scrollbar.h getstring.h remark.h
events.o: symbol.h edit.h buffer.h default.h notatype.h flex.h notadef.h
events.o: notation.h output.h find.h menu.h events.h fileselc.h popup.h
events.o: checkbox.h
find.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
find.o: button.h message.h output.h scrollbar.h keymap.h find.h fileread.h
find.o: fileselc.h notatype.h flex.h editor.h popup.h helpfile.h
getstring.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
getstring.o: keymap.h output.h message.h getstring.h helpfile.h
intstack.o:   intstack.h
keymap.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
keymap.o: message.h output.h keymap.h  ownkeys.h config.h
menu.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h 
menu.o: keymap.h message.h button.h symbol.h edit.h buffer.h default.h
menu.o: notatype.h flex.h notation.h output.h find.h editor.h menu.h popup.h
menu.o: fileselc.h helpfile.h
message.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
message.o: output.h remark.h message.h
notadef.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
notadef.o: keymap.h button.h symbol.h output.h scrollbar.h message.h
notadef.o: notatype.h flex.h notadef.h notation.h popup.h helpfile.h
notation.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
notation.o: button.h scrollbar.h remark.h message.h output.h keymap.h
notation.o: notatype.h flex.h notadef.h notation.h fileselc.h menu.h popup.h
notation.o: helpfile.h 
notatype.o: mathpad.h system.h funcs.h sun_kludge.h debug.h
notatype.o: intstack.h notatype.h flex.h message.h fileread.h output.h
output.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
output.o: message.h output.h buffer.h edit.h intstack.h
remark.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
remark.o: button.h keymap.h getstring.h scrollbar.h output.h remark.h
remark.o: intstack.h helpfile.h
scrollbar.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
scrollbar.o: message.h scrollbar.h helpfile.h
sources.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
sources.o: message.h notatype.h flex.h output.h remark.h intstack.h
sources.o:  config.h progicon
symbol.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
symbol.o: button.h message.h symbol.h keymap.h helpfile.h
system.o:  mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
system.o: config.h
flex.o:  flex.h
fileread.o:  mathpad.h fileread.h debug.h sun_kludge.h
fstate.o:  debug.h fstate.h
fileselc.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
fileselc.o: button.h getstring.h scrollbar.h keymap.h message.h output.h
fileselc.o: fstate.h fileselc.h helpfile.h
popup.o: mathpad.h system.h funcs.h sun_kludge.h debug.h sources.h  
popup.o: output.h popup.h helpfile.h
funcs.o: mathpad.h system.h funcs.h  sun_kludge.h debug.h
helpfile.o: helpfile.h
checkbox.o: mathpad.h system.h funcs.h sun_kludge.h debug.h
checkbox.o: sources.h checkbox.h message.h
leaftree.o:   leaftree.h
match.o: mathpad.h match.h leaftree.h intstack.h debug.h
editor.o:  mathpad.h output.h keymap.h editor.h
editor.o: fileread.h mathpad.hh mark.hh marker.hh node.hh notatype.h flex.h
editor.o: select.hh editwindow.hh mathpad.icc mark.icc marker.icc select.icc
editor.o: editwindow.icc
editwindow.o:  mathpad.h output.h message.h mathpad.hh
editwindow.o: mark.hh marker.hh node.hh notatype.h flex.h select.hh
editwindow.o: editwindow.hh mathpad.icc mark.icc marker.icc select.icc
editwindow.o: editwindow.icc
mark.o:  mathpad.h mathpad.hh mark.hh marker.hh
mark.o: node.hh notatype.h flex.h mathpad.icc mark.icc marker.icc select.icc
mark.o: editwindow.icc
marker.o:  mathpad.h mathpad.hh mark.hh marker.hh node.hh
marker.o: notatype.h flex.h mathpad.icc mark.icc marker.icc select.icc
marker.o: editwindow.icc
mathpad.o: events.h
node.o:   debug.h mathpad.h flex.h notatype.h output.h message.h fileread.h 
node.o: mathpad.hh mark.hh marker.hh node.hh mathpad.icc mark.icc marker.icc
node.o: select.icc editwindow.icc
select.o:  message.h mathpad.h debug.h mathpad.hh mark.hh
select.o: marker.hh node.hh notatype.h flex.h select.hh editwindow.hh
select.o: mathpad.icc mark.icc marker.icc select.icc editwindow.icc
