.TH MATHPAD    1    "22 February 1996"

.SH NAME
mathpad \- an X editor for mathematical LaTeX documents

.SH SYNOPSIS
\fBmathpad\fP [\-display \fIdisplay\fP] [\-iconic] [\-ascii] [\-plain] [\-gray] [\-bg\fIselection\fP \fIcolor\fP] [\-fg\fIselection\fP \fIcolor\fP]
[\-colors \fInumber\fP] [\-fonts \fIname\fP] [[\-project] \fIname\fP]

.SH DESCRIPTION
Mathpad is an X editor for mathematical documents, although it  can
also be used for normal text. A document contains normal \fIascii\fP in
combination with \fIspecial symbols\fP and \fIexpressions\fP. The expressions are
built with defined \fItemplates\fP which makes it possible to edit expressions
very fast. The expressions are readable and a number of special functions
are available to manipulate them.
.PP
Mathpad is a very \fIflexible\fP editor. Almost every available font can be used
in mathpad, even the proportional ones. Multiple fonts are used to switch
between fonts and to be able to insert special mathematical symbols or
foreign characters. Every user can add his own fonts.
.PP
Unlike most editors, you can define your \fIown templates\fP in mathpad. A
template can contain arguments and contains a \fIscreen\fP definition and a
\fILaTeX\fP definition which can be defined independently. In the screen
definition you can use different fonts, different sizes, a tabbing environment,
a short stack to place expression above each other and horizontal and
vertical lines. The relating LaTeX definition does not depend on the screen
definition which makes it possible to simulate most of the LaTeX
constructions in mathpad.  \fISubscripts\fP, \fIsuperscript\fP, \fIroots\fP, \fIfractions\fP,
\fIsummations\fP, \fIaccents\fP, \fIunderlining\fP and \fIoverlining\fP are possible and
look almost WYSIWYG in mathpad. Also \fIarrays\fP and \fItabulars\fP can
be partially simulated with the tabbing environment.
.PP
Although mathpad produces LaTeX by default, it is also possible to
edit other kind of documents. Without much trouble you can edit normal
ascii, troff, HTML and programs. For example, this manpage is made with
mathpad and is very readable on screen.
.PP
Mathpad will not used the standard input or standard output. Standard
error is used when error messages occur while the message window
is not open.

.SH OPTIONS
Mathpad does \fInot\fP support the usual X options to change colors or sizes
from the command line. The following options are available:
.IP "\fB\-display\fP \fIdisplay\fP" 8
Specifies the name of the X server to connect to, which can be used
run mathpad on a remote system. Note that the fonts must be
available on the host where the X server runs.
.IP "\fB\-iconic\fP" 8
Start mathpad as an icon. If this is used in combination with the
project option, all the windows from the project file will start as an
icon.
.IP "\fB\-ascii\fP" 8
Generate ascii instead of LaTeX as default output.
.IP "\fB\-plain\fP" 8
Produce LaTeX code almost as you would type it. Mathpad
will not add the spacing around operators, which is now done
by the LaTeX program itself.
.IP "\fB\-fonts\fP \fIname\fP" 8
Start mathpad with a font definition file. The font definition file
describes which fonts are available, which LaTeX macros are
attached to the symbols and how these fonts are used in LaTeX.
By default, mathpad uses the file fonts.mpt. The font definition
file can be used to generate troff or HTML instead of LaTeX
.IP "\fB\-gray\fP" 8
Use the grayscale colors. Mathpad will often use the
normal colors on a grayscale monitor and the selections will
all look the same.
.IP "\fB\-bg\fIselection\fP\fP \fIcolor\fP" 8
Set the background color of a particular selection. If you not like
the default color selection, you can use a number of these options to
change the colors of each selection.  The \fIselection\fP is specified with
a string where 't', 'T' or '1' are used for the target selection, 's', 'S'
or '2' for the source selection and 'a',  'A' or '3' for the argument
selection. To specify a combination of selection, you can use the
combination of charactors. The \fIcolor\fP argument can be the name of a
color or the RBG number.
.IP "\fB\-fg\fIselection\fP\fP \fIcolor\fP" 8
Set the foreground color of a particular selection. See the previous item
for the explanation.
.IP "\fB\-colors\fP \fInumber\fP" 8
Limit the number of colors to \fInumber\fP. By default, mathpad tries
to use 16 colors to make color selections possible. If you want to use
these colors in a different program or mathpad makes incorrect
selections, you can restrict mathpad to use only 2, 4 or 8 colors.
If mathpad can not use enough colors, it will use underlining to
make the different selections visible.
.IP "\fB\-project\fP \fIname\fP" 8
Start mathpad with a project file. The project file describes which
files are loaded and where the different windows are located. A
project file is during a previous session with mathpad and will be
made when the save workspace is used. The project file should be
placed in the users mathpad directory.
.PP
Mathpad does not use the directory where it is started in. Instead, a
default file is used with a number of directories and some other
information about fonts and layout.

.SH USAGE

.SS Opening Window
When mathpad is started, a window will appear that contains a number
of buttons and a \fImessage bar\fP. Each of these button is used to open a pinup menu
(third button) or to perform the default action of that pinup menu. The
default action of a pinup menu is usually the first item. If you want to use
a pinup menu multiple times, you might consider to pin it up by selecting
the header of the menu.
.PP
For each window that you open, you can get help by moving the mouse pointer
inside the window and press the \fBhelp\fP key (or \fIshift-F10\fP if you do not have
a help key). Note that each button is also a window. Just in case this help facility
does not work, a short description of the available buttons in the menu window.
.IP "\fBWindow\fP" 8
Open a new window. There are six different windows: \fIDocument\fP, to edit a new
document,  \fIStencil\fP, to edit or a use a file with templates, \fISymbol\fP, to select strange
symbols, \fIFind\fP, to find and/or replace expressions or text, \fIBuffer\fP, to use parts
which you removed by accident (a primitive undo), and \fIDefault\fP, to change
the defaults. Each window has its own buttons to perform further actions.
.IP "\fBEditOp\fP" 8
To perform some standard edit operations: \fICopy\fP, \fISwap\fP and \fIDelete\fP.
.IP "\fBStructure\fP" 8
To change the structure of expressions: Add or remove braces, \fIReverse\fP, \fIDistribute\fP,
\fIFactorise\fP, \fIApply\fP, \fIGroup\fP, \fIUngroup\fP and \fIRename\fP.
.IP "\fBSelection\fP" 8
To change the selections, but not the contents of the selections: \fISwap\fP, \fIClear\fP and \fIJoin\fP.
.IP "\fBMisc.\fP" 8
Some miscellaneous functions: \fIWord Wrap\fP, Selection to LaTeX, \fIPaste\fP, \fIGoto Line\fP,
Toggle Dots,  Adjust Spacing, Spell Checking, running LaTeX and an experimental
interface to Maple.
.IP "\fBVersion\fP" 8
To switch between the versions of a template. The pinup that appears depends on
the selection that is made. 
.IP "\fBQuit\fP" 8
To stop with mathpad or to save your project. For each \fIunsaved\fP document
or stencil file, a popup will appear asking if it should be saved.

Just use the help facility if you want to know more about a certain function..

.SS Selections.
Mathpad uses \fIthree\fP selections which are made by clicking or dragging.
Also the \fIdouble click\fP (and drag) can be used to select complete words or
lines. The selections can be made with the three mouse buttons and the
colors mentioned here are the default colors that mathpad uses.
.IP "\fBTarget\fP" 8
This selection is made with the left mouse button and is displayed as a
cursor or in \fIreverse mode\fP. It is used as the target of the available
functions.
.IP "\fBSource\fP" 8
This selection is made with the middle mouse button and is displayed
on a blue background or with a \fIthick\fP underline. It is used in the copy
and swap functions and to define a body of a function.
.IP "\fBArgument\fP" 8
This selection is made with the right mouse button and is displayed
on a cyan background or with a \fIthin\fP underline. It is used to define the
position of the argument within a function or the scope. It is not used very
often.
.PP
If you combine the selections, you can get some strange results.  If your mouse
does not have three button, you can use the \fBCtrl\fP key to increase the button
number by one and the \fBMeta\fP key to increase the button number by two.
.PP
The primary selection is \fInot\fP automaticly available for the window system.
The selection can be converted to LaTeX and is made available by using
the \fBF10\fP key.
.PP
A selection from the window system can be inserted with the \fBPaste\fP (L8)
or the \fBF3\fP key. In mathpad only text can be inserted.
.PP
You can use the window system to copy the LaTeX version of an expression
in mathpad. Select the expression, hit the \fBF10\fP key, position the cursor and
hit the \fBPaste\fP key.

.SS Keyboard commands
At the moment the keyboard commands of mathpad are almost equal to those
from \fIemacs\fP. This means that you can use the normal cursor keys, you can
insert text with the normal keys and delete it with the delete and backspace
keys. For more specific functions, place the mouse pointer in a Document
window and press the \fBhelp\fP key (or \fIshift-F10\fP). The main extra key
combinations are:
.IP "\fBM-L\fP" 8
Move to a specific line. The line numbers between the output files
and the mathpad document differ and LaTeX errors would be hard to
find without this function.
.IP "\fBM-P\fP" 8
Make a \fIproject file\fP. Mathpad used project files to save configuration. A
project file contains the specified defaults from the default window, a
list of loaded stencil files and documents and the locations and sizes of
the opened or iconised windows. The project file is also used when the
workspace is saved.

.SS Getting Help
Mathpad has a help system that consists of documents that can be loaded.
These documents explain the different  parts of mathpad and indicate what is
possible. The documents are located in the help directory of the distribution
which is available to every user. You can use the \fBhelp\fP key (or \fIshift-F10\fP)
to get help on the window where the mouse pointer is located.

.SS Signal Processing
Mathpad catches the fatal signals to ensure that a last minute backup
can be made if needed. Such a backup will get the name \fBdump\fP\fIname\fP. If
mathpad should hang for some reason, you can send the terminate signal
with the call \fBkill\fP \fIpid\fP. Mathpad will make backups for the unsaved documents if
possible.
.PP
Mathpad also has an \fIautomatic save\fP which will save all the documents
and stencil files in backup files if necessary. The backups have the name
\fB\#\fP\fIname\fP\fB\#\fP and can be loaded when errors should occur. If a document
is saved successfully, the backup is removed.
.PP
If the connection to the window system is lost, mathpad will dump the
unsaved documents in files and quit. Other errors are also caught
although they will not always be fatal.
.PP
In the rare situation that mathpad or the window system should crash
the backup files and dump files can be used like normal document.
However, mathpad does not check if the backup file is better then the
original. So, after a crash, load the backup first or look at the document
without editing.

.SH ENVIRONMENT
Mathpad uses the following environment variables, which are usually
only needed when mathpad is installed (t.i. in a shell script)..
.IP "\fBHOME\fP" 8
The home directory of the user.
.IP "\fBMATHPADHOME\fP" 8
The directory where the distribution files are located.
.IP "\fBMATHPADLATEX\fP" 8
The directory with the LaTeX macros and LaTeX style files mathpad
uses. At the moment is variable is not really used.
.IP "\fBMATHPADSTENCIL\fP" 8
The directory with the distribution files. If a specific stencil file is not
found in the users directory, this directory will be used.
.IP "\fBMATHPADFONTS\fP" 8
The default font that should be used when no default file is available.
.IP "\fBMATHPADHELPPATH\fP" 8
The path to look for help document. By default, mathpad will search in
your ~/mathspad/help directory and the distribitions help directory.
.IP "\fBMATHPADKEYS\fP" 8
The keyboard files that should be loaded by default which is useful
if you work with different terminals using the same account. At the
moment, changing the keyboard is a little difficult but possible.
.IP "\fBMATHPADFONTPATH\fP" 8
Add the specified font path to the existing font path. Mathpad uses a
number of extra fonts and the font path of the server can be changed
using this variable.  If no font path should be added, this variable
should be set to the empty string.
.PP
If these variable are not set, mathpad will use the built-in defaults. However,
mathpad will use MATHPADHOME to determine correct values for
MATHPADSTENCIL (+/stencil), MATHPADLATEX (+/latex) and
MATHPADFONTPATH (+/fonts).

.SH FILES
MATHPADLIBDIRECTORY/*
.PP
$HOME/.mpdefaults
.PP
$HOME/mathspad/.mpproject.mpj


.SH BUGS

If you find any bugs, no mather how small, you can report them to  mathpad@win.tue.nl .
Also comments or suggestions are welcome.

