/***************************************************************************\
*									    *
*   WINDOWSX.H								    *
*									    *
*   Some headers are used from the cygnus project			    *
*   Modified by:							    *
*    kiefer@isys.de							    *
*    rainer@mathematik.uni-bielefeld.de 				    *
*									    *
\***************************************************************************/

#if !defined (_WINDOWSX_H)
#define _WINDOWSX_H

#ifdef __cplusplus
extern "C" {
#endif

#define HANDLE_WM_COMMAND(hwnd, wParam, lParam, fn) ((fn)((hwnd), (int)(LOWORD(wParam)), (HWND)(lParam), (UINT)HIWORD(wParam)), 0L)
#define FORWARD_WM_COMMAND(hwnd, id, hwndCtl, codeNotify, fn) (void)(fn)((hwnd), WM_COMMAND, MAKEWPARAM((UINT)(id),(UINT)(codeNotify)), (LPARAM)(HWND)(hwndCtl))

#define HANDLE_WM_CREATE(hwnd, wParam, lParam, fn) ((fn)((hwnd), (LPCREATESTRUCT)(lParam)) ? 0L : (LRESULT)-1L)
#define FORWARD_WM_CREATE(hwnd, lpCreateStruct, fn) (BOOL)(DWORD)(fn)((hwnd), WM_CREATE, 0L, (LPARAM)(LPCREATESTRUCT)(lpCreateStruct))

#define HANDLE_WM_DESTROY(hwnd, wParam, lParam, fn) ((fn)(hwnd), 0L)
#define FORWARD_WM_DESTROY(hwnd, fn) (void)(fn)((hwnd), WM_DESTROY, 0L, 0L)

#define HANDLE_WM_INITMENUPOPUP(hwnd, wParam, lParam, fn) ((fn)((hwnd), (HMENU)(wParam), (UINT)LOWORD(lParam), (BOOL)HIWORD(lParam)), 0L)
#define FORWARD_WM_INITMENUPOPUP(hwnd, hMenu, item, fSystemMenu, fn) (void)(fn)((hwnd), WM_INITMENUPOPUP, (WPARAM)(HMENU)(hMenu), MAKELPARAM((item),(fSystemMenu)))

#define HANDLE_WM_MENUSELECT(hwnd, wParam, lParam, fn) \
    ((fn)((hwnd), (HMENU)(lParam),  \
    (int)(LOWORD(wParam)),	    \
    (HIWORD(wParam) & MF_POPUP) ? GetSubMenu((HMENU)lParam, LOWORD(wParam)) : 0L, \
    (UINT)(((short)HIWORD(wParam) == -1) ? 0xFFFFFFFF : HIWORD(wParam))), 0L)

#define HANDLE_WM_MOUSEMOVE(hwnd, wParam, lParam, fn) ((fn)((hwnd), (int)(short)LOWORD(lParam), (int)(short)HIWORD(lParam), (UINT)(wParam)), 0L)

#define HANDLE_WM_SETFOCUS(hwnd, wParam, lParam, fn) ((fn)((hwnd), (HWND)(wParam)), 0L)
#define FORWARD_WM_SETFOCUS(hwnd, hwndOld, fn) (void)(fn)((hwnd), WM_SETFOCUS, (WPARAM)(HWND)(hwndOld), 0L)

#define HANDLE_WM_SIZE(hwnd, wParam, lParam, fn) ((fn)((hwnd), (UINT)(wParam), (int)(short)LOWORD(lParam), (int)(short)HIWORD(lParam)), 0L)
#define FORWARD_WM_SIZE(hwnd, state, cx, cy, fn) (void)(fn)((hwnd), WM_SIZE, (WPARAM)(UINT)(state), MAKELPARAM((cx), (cy)))

#define HANDLE_WM_TIMER(hwnd, wParam, lParam, fn) ((fn)((hwnd), (UINT)(wParam)), 0L)

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINDOWSX_H) */
