/*
** generate 32bit windows file
** with packed structures
**
** (c) Rainer Schnitker
**
** call: makewin windows.h [output-file]
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char attr_name[] = " __attribute__((packed)) ";
static char struct_compare[] = "typedef struct";

#define MAX_CHARS 256
static char line_buf[MAX_CHARS];
static int pos = 0;

int my_fgetc(FILE *input)
{
    int ch = fgetc(input);

    line_buf[pos++] = (char) ch;
    line_buf[pos] = 0;

    if (ch == '\n' || pos == MAX_CHARS-1) {
	pos = 0;
	line_buf[0] = 0;
    }

    return ch;
}

void convert_windows_h(FILE *input, FILE *output)
{
    int c;
    int level = 0;

    while ((c = my_fgetc(input)) != EOF) {
	switch (c) {
	    case '{':
		if (level == 1)
		    level++;
		break;
	    case '}':
		level = 0;
		break;
	    case ';':
		if (level == 2)
		    fwrite(attr_name, sizeof(attr_name)-1, 1, output);
		break;
	    case 't':
		if (pos == 14 && strcmp(line_buf, struct_compare) == 0)
		    level = 1;
		break;
	}
	fputc(c, output);
    }
}

int main(int argc, char **argv)
{
    FILE *input;
    FILE *output;

    if (argc < 2) {
	puts("usage: makewin 16bitWindowsFile [32bitWindowsFile]");
	exit(1);
    }
    if ((input = fopen(argv[1], "rt")) == NULL) {
	perror(argv[1]);
	return 1;
    }

    if (argc < 3)
	output = stdout;
    else if ((output = fopen(argv[2], "wt")) == NULL) {
	perror(argv[2]);
	return 1;
    }

    convert_windows_h(input, output);
    fclose(input);
    fclose(output);
    return 0;
}
