#include "nodefs.h"
#include <windows.h>
#include <sys/port.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __EMX__
#define itoa _itoa
#endif
#include "GNUGO.H"
#include "NONWIN.H"
#include "SAVEOPEN.H"


#define EMPTY 0
#define WHITE 1
#define BLACK 2
#define SPACE 10

/* vars in dosversion */
int p[19][19];
int mymove=WHITE , umove=BLACK;
int rd, lib, play, pass;
int mik, mjk, uik, ujk, mk, uk;
int opn[9];
int handicap=0;


/* vars for windowsversion */
char szAppname[] = "GNUGO";
int old[19][19];		    /* board befor move */
int dcx[20][20] , dcy[20][20] ;     /* DCpoints of fields(left-top corner) */
int px,py=15,sx,sy=2;		    /* field xy-width , space to piece xy-width */
int text_x;			    /* textout x */



void fail(HWND hwnd,BYTE *s)
{
    MessageBox(hwnd,s,szAppname,MB_OK);
}


void initdcpoints() /* set dcpoints for board */
{
    int i,j ;

    for (i=0;i<=19;i++)
	   for (j=0;j<=19;j++) {
		    dcx[i][j] = SPACE + i*(px);
		    dcy[i][j] = SPACE + j*(py);
		    }
    text_x =  SPACE + 20*px ;	/* for textout */
}

void initglobals() /* set fields EMPTY ,set globels */
{
    int i,j ;

    for (i=0;i<=18;i++)
	   for (j=0;j<=18;j++)
		{
		p[i][j]=EMPTY;
		old[i][j]=EMPTY;
		}
    mk=0;
    uk=0;
    for (i = 0; i < 9; i++)
	opn[i] = 1;
    opn[4] = 0;

    play = 1;
    pass = 0;
    mik = -1; mjk = -1;
    uik = -1; ujk = -1;
    seed(&rd);
}

void wmpaint(HDC hdc) /* Picasso cames after WM_PAINT */
{
    int i,j;
    HANDLE holdWhiteBrush;
    HBRUSH hGreyBrush , hBlackBrush ;
    int dx,dy;

    hGreyBrush = CreateSolidBrush(RGB( 128, 128, 128));
    hBlackBrush =  CreateSolidBrush(RGB( 0, 0 , 0));

    holdWhiteBrush=SelectObject(hdc,hGreyBrush);   /* Grey all fields */
    Rectangle(hdc,dcx[0][0]-1,dcy[0][0]-1,dcx[19][19]+1,dcy[19][19]+1);
    dx=(px>>1)+1;dy=(py>>1)+1;
    for (i=0;i<=18;i++)
	    {
	    MoveTo(hdc,dcx[i][0]+dx,dcy[i][0]);
	    LineTo(hdc,dcx[i][18]+dx,dcy[i][19]);
	    MoveTo(hdc,dcx[0][i],dcy[0][i]+dy);
	    LineTo(hdc,dcx[19][i],dcy[18][i]+dy);
	    }

    dx=px-sx; dy=py-sy;

    SelectObject(hdc,hBlackBrush); /* Black pieces */
    for (i=0;i<=18;i++)
	for (j=0;j<=18;j++)
	    if (p[i][j]==BLACK)
		Ellipse(hdc,dcx[i][j]+sx,dcy[i][j]+sy,dcx[i][j]+dx,dcy[i][j]+dy);

    SelectObject(hdc,holdWhiteBrush); /* White pieces */
    for (i=0;i<=18;i++)
	for (j=0;j<=18;j++)
	    if (p[i][j]==WHITE)
		Ellipse(hdc,dcx[i][j]+sx,dcy[i][j]+sy,dcx[i][j]+dx,dcy[i][j]+dy);

    DeleteObject(hGreyBrush);
    DeleteObject(hBlackBrush);

    if (umove==BLACK)
	 TextOut(hdc,text_x,30,"You are black",13);
    else TextOut(hdc,text_x,30,"You are white",13);

    TextOut(hdc,text_x,100,"You capture:",12);
    TextOut(hdc,text_x,140,"I capture:",10);

    showpoints(hdc);   /* show score */
}

void repaint(HWND hwnd) /* paint only new points */
{
    int i,j;
    HDC hdc;
    HANDLE holdbrush;
    HBRUSH hGreyBrush , hBlackBrush ;
    HPEN hpen,holdpen;
    int dx,dy;

    hdc=GetDC(hwnd);

    hGreyBrush =  CreateSolidBrush(RGB( 128, 128, 128));
    hBlackBrush = CreateSolidBrush(RGB(  0, 0 , 0));

    dx=px-sx; dy=py-sy;

    for (i=0;i<=18;i++)     /* new white pieces */
	for (j=0;j<=18;j++)
	    if (p[i][j]==WHITE && old[i][j]!=WHITE ) {
		old[i][j]=WHITE;
		Ellipse(hdc,dcx[i][j]+sx,dcy[i][j]+sy,dcx[i][j]+dx,dcy[i][j]+dy);
		}

    holdbrush=SelectObject(hdc,hBlackBrush); /* new black pieces */
    for (i=0;i<=18;i++)
	for (j=0;j<=18;j++)
	    if (p[i][j]==BLACK && old[i][j]!=BLACK ) {
		old[i][j]=BLACK;
		Ellipse(hdc,dcx[i][j]+sx,dcy[i][j]+sy,dcx[i][j]+dx,dcy[i][j]+dy);
		}

    SelectObject(hdc,hGreyBrush);	/* Grey empty fields ,draw lines */

    hpen=CreatePen(PS_NULL,0,(COLORREF)0L);
    holdpen=SelectObject(hdc,hpen);

    dx=(px>>1)+1;dy=(py>>1)+1;
    for (i=0;i<=18;i++)
	for (j=0;j<=18;j++)
	    if (p[i][j]==EMPTY && old[i][j]!=EMPTY ) {
		old[i][j]=EMPTY;
		SelectObject(hdc,hpen);
		Rectangle(hdc,dcx[i][j],dcy[i][j],dcx[i+1][j+1],dcy[i+1][j+1]);
		SelectObject(hdc,holdpen);
		MoveTo(hdc,dcx[i][j]+dx,dcy[i][j]);
		LineTo(hdc,dcx[i][j]+dx,dcy[i+1][j+1]);
		MoveTo(hdc,dcx[i][j],dcy[i][j]+dy);
		LineTo(hdc,dcx[i+1][j+1],dcy[i][j]+dy);
		}

    SelectObject(hdc,holdpen);
    DeleteObject(hpen);

    SelectObject(hdc,holdbrush);
    DeleteObject(hGreyBrush);
    DeleteObject(hBlackBrush);

    showpoints(hdc);	     /* show score */
    ReleaseDC(hwnd,hdc);
}

void showpoints(HDC hdc)  /* show score */
{
    static char points[9];

    _itoa(mk,points,10);
    TextOut(hdc,text_x+10,115,points,strlen(points));
    itoa(uk,points,10);
    TextOut(hdc,text_x+10,155,points,strlen(points));
    if (play==-1) {
	TextOut(hdc,text_x+50,115,"total",5);
	TextOut(hdc,text_x+50,155,"total",5);
	if (mk>uk)
	    TextOut(hdc,text_x,175,"I lost !",8);
	else if (mk<uk)
		TextOut(hdc,text_x,175,"I win !",7);
	}
}

BOOL moveplayer(HWND hwnd,int x,int y) /* check if mouse-move is ok, play move */
{
    int i,j;
    BOOL ok;

    ok=FALSE;
    for (i=0;i<=18;i++)
      for (j=0;j<=18;j++)
	if ( (dcx[i][j]<x)&&(dcx[i][j]+px>x)&&(dcy[i][j]<y)&&(dcy[i][j]+py>y) )
	    {
	    ok=TRUE;
	    goto movebrk ;
	    }
    movebrk:
    if (ok==FALSE) return FALSE ;

    if (p[i][j]!=EMPTY || suicide(i,j) )
	{
	fail(hwnd,"illegal move");
	return FALSE;
	}
    p[i][j]=umove;
    examboard(mymove);
    return TRUE;
}

BOOL getdeadpieces(int x,int y) /* check mouse-move for removing pieces */
{
    int i,j;
    BOOL ok;

    ok=FALSE;
    for (i=0;i<=18;i++)
      for (j=0;j<=18;j++)
	if ( (dcx[i][j]<x)&&(dcx[i][j]+px>x)&&(dcy[i][j]<y)&&(dcy[i][j]+py>y) )
	    {
	    ok=TRUE;
	    goto deadbrk ;
	    }
    deadbrk:
    if (ok==FALSE) return FALSE ;

    if (p[i][j]==mymove)
	{
	p[i][j]=EMPTY;
	mk++;
	return TRUE;
	}
    if (p[i][j]==umove)
	{
	p[i][j]=EMPTY;
	uk++;
	return TRUE;
	}
    return FALSE;
}

void greymenu(HMENU hmenu)
{   /* if removing dead pieces not save,load,pass  but enable stop */
    EnableMenuItem(hmenu,IDM_LOAD,play ? MF_ENABLED : MF_GRAYED );
    EnableMenuItem(hmenu,IDM_SAVE,play ? MF_ENABLED : MF_GRAYED );
    EnableMenuItem(hmenu,IDM_PASS,play ? MF_ENABLED : MF_GRAYED );
    EnableMenuItem(hmenu,IDM_STOP,play ? MF_GRAYED : MF_ENABLED );
}

void countnow()
{
    int i, j;

    /* set empty to side they belong to */
    for (i = 0; i < 19; i++)
	for (j = 0; j < 19; j++)
	    if (p[i][j] == EMPTY)
		p[i][j] = findcolor(i, j);

    /* count total */
    mk = 0;  uk = 0;
    for (i = 0; i < 19; i++)
	for (j = 0; j < 19; j++)
	    if (p[i][j] == mymove)
		++uk;
	    else
	    if (p[i][j] == umove)
		++mk;
}

void loadgame(char *name)
{
   FILE *fp;
   int i, j;

    if ((fp = fopen(name,"r")) != NULL) {
	for (i = 0; i < 19; i++)
	    for (j = 0; j < 19; j++)
		p[i][j] = old[i][j] = fgetc(fp);
	mymove = fgetc(fp);
	mk = fgetc(fp);
	uk = fgetc(fp);
	for (i = 0; i < 9; i++)
	    opn[i] = fgetc(fp);
	fclose(fp);
	umove = 3 - mymove;
    }
}

void savegame(char *name)
{
    FILE *fp;
    int n, m;

    if ((fp = fopen(name,"w")) != NULL) {
	for (m = 0; m < 19; m++)
	    for (n = 0; n < 19; n++)
		fputc(p[m][n], fp);
	fputc(mymove, fp);
	fputc(mk, fp);
	fputc(uk, fp);
	for (m = 0; m < 9; m++)
	    fputc(opn[m], fp);
	fclose(fp);
    }
}

long FAR PASCAL WndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    static HMENU hmenu;
    static HANDLE hInstance;
    static char str[80];
    static char FileName[128];
    HDC hdc;
    PAINTSTRUCT ps;
    BOOL ok;
    int i,j;
    int logx,logy;
    FARPROC lpfnNewGameDlgProc;
    LPCREATESTRUCT lpcrst;
    static HCURSOR hHourGlass;
    HCURSOR hOldCursor;
    OFSTRUCT pof;
    WORD Status;
    int hFile ;

    switch (message)
    {
	case WM_CREATE:
	    lpcrst = (LPCREATESTRUCT) LONG2PTR(lParam) ;
	    hInstance = lpcrst->hInstance;
	    hmenu = GetMenu(hwnd);

	    hdc=GetDC(hwnd);
	    logx=GetDeviceCaps(hdc,LOGPIXELSX);    /* stretch x */
	    logy=GetDeviceCaps(hdc,LOGPIXELSY);
	    ReleaseDC(hwnd,hdc);

	    sx=MulDiv(sy,logx,logy);	    /* sx=sy*logx/logy */
	    px=MulDiv(py,logx,logy);
	    if ( !(px % 2) ) px++;

	    initdcpoints();
	    initglobals();
	    greymenu(hmenu);

	    hHourGlass=LoadCursor(NULL,IDC_WAIT);
	    return 0;

	case WM_PAINT:
	    hdc = BeginPaint(hwnd, &ps);
	    wmpaint(hdc);
	    EndPaint(hwnd, &ps);
	    return 0;

	case WM_SIZE:
	    return 0;

	case WM_DESTROY:
	    PostQuitMessage(0);
	    return 0;

	case WM_LBUTTONDOWN :
	    switch (play)
	    {
	    case 1 :
		{
		if (moveplayer(hwnd,LOWORD(lParam),HIWORD(lParam)) )
		    {
		    pass=0;
		    SendMessage(hwnd,MSG_REPAINT,0,0L);
		    PostMessage(hwnd,MSG_COMPUTERMOVE,0,0L);
		    }
		}
		break;

	    case 0 :
		{
		if (getdeadpieces(LOWORD(lParam),HIWORD(lParam)))
		    SendMessage(hwnd,MSG_REPAINT,0,0L);
		else fail(hwnd,"Feld ist leer!");
		}
		break;

	    case -1 :
		fail(hwnd,"Begin a new game");
		break;
	    }
	    return 0;

	case MSG_COMPUTERMOVE :
	    hOldCursor=SetCursor(hHourGlass);
	    genmove(&i,&j); /* computer move */
	    if (i>0)  /* not pass */
		{
		pass=0;
		p[i][j]=mymove;
		examboard(umove);
		SendMessage(hwnd,MSG_REPAINT,0,0L);
		}
	    else {
		pass++;
		if (pass>1)
		    {
		    play=0;
		    fail(hwnd,"I pass too\n\nGame stopped !\n"
			"Delete dead pieces now !\n\n"
			"Send stop if you are ready");
		    }
		else fail(hwnd,"I pass !");
		}
	    SetCursor(hOldCursor);
	    return 0;

	case MSG_REPAINT :
	    repaint(hwnd);
	    return 0;

	case WM_COMMAND :
	    switch (wParam)
	    {
		case IDM_SETUP :
		    initglobals();
		    lpfnNewGameDlgProc=MakeProcInstance(NewGameDlgProc,hInstance);
		    DialogBox(hInstance,"NEWGAME",hwnd,lpfnNewGameDlgProc);
		    FreeProcInstance(lpfnNewGameDlgProc);
		    InvalidateRect(hwnd, (LPRECT) NULL, TRUE);
		    greymenu(hmenu);
		    UpdateWindow(hwnd);
		    if ( (handicap!=0 && mymove==WHITE) || (handicap==0 && mymove==BLACK))
			SendMessage(hwnd,MSG_COMPUTERMOVE,0,0L);
		    return 0;

		case IDM_SAVE :
		   if (!DoFileSaveDlg(hInstance,hwnd,"name.go",".go",&Status,
			FileName,&pof)) return 0;
		   if (Status==1) {
		      strcpy(str,"Replace Existing ");
		      strcat(str,FileName);
		      if (MessageBox(hwnd,str,szAppname,MB_YESNO | MB_ICONQUESTION)==IDNO)
		      return 0;
		   }
		   else OpenFile (FileName, &pof, OF_PARSE);
		   savegame(pof.szPathName);
		   return 0;

		case IDM_LOAD :
		    if (!DoFileOpenDlg(hInstance,hwnd,"*.go",".go",0,FileName,&pof))
		    return 0;

		    if ( (hFile=OpenFile(FileName, &pof, OF_READ|OF_REOPEN)) == -1) {
			strcpy ( str, "Cannot open file: ");
			strcat ( str, FileName);
			MessageBox (hwnd, str, szAppname,MB_OK | MB_ICONQUESTION);
			return 0;
			}
		    _lclose ( hFile );

		    initglobals();
		    loadgame(pof.szPathName);
		    greymenu(hmenu);
		    InvalidateRect(hwnd, (LPRECT) NULL, TRUE);
		    UpdateWindow(hwnd);
		    return 0;

		case IDM_EXIT :
		    SendMessage(hwnd,WM_CLOSE,0,0L);
		    return 0;

		case IDM_PASS :
		    pass++;
		    if (pass>1)
			{
			play=0;
			fail(hwnd,"Game stopped !\n"
			    "Delete dead pieces now !\n\n"
			    "Send stop if you are ready");
			greymenu(hmenu);
			}
		    else
			PostMessage(hwnd,MSG_COMPUTERMOVE,0,0L);
		    return 0;

		case IDM_STOP :
		    countnow();
		    play=-1;
		    greymenu(hmenu);
		    SendMessage(hwnd,MSG_REPAINT,0,0L);
		    return 0;

		case IDM_HELP  :
		    fail(hwnd,"Help not implemented");
		    return 0;

		case IDM_ABOUT :
		   MessageBox(hwnd,
			"     GNU GO - the game of Go (Wei-Chi)\n"
			"Copyright (C) Free Software Foundation, Inc.\n\n"
			"   DOS-Version 1.1   last revised 3-1-89\n"
			"           written by Man L. Li\n"
			"           modified by Wayne Iba\n"
			"         documented by Bob Webber\n\n"
			" WINDOWS-modifications last revised 2-92\n"
			"         written by Rainer Schnitker\n",
			    szAppname, MB_OK);
		   return 0;


	    }
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}

INT PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdParam, INT nCmdShow)
{
    HWND hwnd;
    MSG msg;
    WNDCLASS wndclass;

    if (! hPrevInstance)
    {
	wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
	wndclass.lpfnWndProc = (FARPROC)WndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = hInstance;
	wndclass.hIcon = LoadIcon(hInstance, szAppname);
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName = szAppname;
	wndclass.lpszClassName = szAppname;
	RegisterClass(&wndclass);
    }

    hwnd = CreateWindow(szAppname, szAppname,
			WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX,
			100 , 5 , 550 , 345 ,
			NULL, NULL, hInstance, NULL);

    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);

    while (GetMessage(&msg, NULL, 0, 0))
    {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }

    return msg.wParam;
}

BOOL FAR PASCAL NewGameDlgProc(HWND hwnd,WORD message,WORD wParam,LONG lParam)
{
    char szText[20];
    static int i,u;

    switch (message)
	{
	case WM_INITDIALOG :
	    i=mymove;
	    u=umove;
	    CheckRadioButton(hwnd,IDD_BLK,IDD_WTE,
		    (2-umove) ? IDD_WTE : IDD_BLK);
	    itoa(handicap,szText,10);
	    SetDlgItemText(hwnd,IDD_HANDI,szText);
	    return TRUE;

	case WM_COMMAND :
	    switch (wParam)
		{
		case IDD_BLK :
		    u= BLACK ;
		    i= WHITE ;
		    CheckRadioButton(hwnd,IDD_BLK,IDD_WTE,wParam);
		    return TRUE ;
		case IDD_WTE :
		    u= WHITE ;
		    i= BLACK ;
		    CheckRadioButton(hwnd,IDD_BLK,IDD_WTE,wParam);
		    return TRUE ;
		case IDOK :
		    mymove=i;
		    umove=u;
		    GetDlgItemText(hwnd,IDD_HANDI,szText,20);
		    handicap=atoi(szText);
		    if (handicap>17) handicap=17;
		    if (handicap<0)  handicap=0;
		    sethand(handicap);
		    EndDialog(hwnd,TRUE);
		    return TRUE;
		case IDCANCEL :
		    sethand(handicap);
		    EndDialog(hwnd,FALSE);
		    return TRUE;
		}
	    break;
	}
	return FALSE;
}

